/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.chunk.AbstractRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.reader.DimensionColumnChunkReader;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageDecoder;
import org.apache.carbondata.core.datastore.page.encoding.DefaultEncodingFactory;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonDictionaryImpl;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.LocalDictionaryChunk;

public class DimensionRawColumnChunk
extends AbstractRawColumnChunk {
    private DimensionColumnPage[] dataChunks;
    private DimensionColumnChunkReader chunkReader;
    private FileReader fileReader;
    private CarbonDictionary localDictionary;

    public DimensionRawColumnChunk(int columnIndex, ByteBuffer rawData, long offSet, int length, DimensionColumnChunkReader columnChunkReader) {
        super(columnIndex, rawData, offSet, length);
        this.chunkReader = columnChunkReader;
    }

    public DimensionColumnPage[] decodeAllColumnPages() {
        if (this.dataChunks == null) {
            this.dataChunks = new DimensionColumnPage[this.pagesCount];
        }
        for (int i = 0; i < this.pagesCount; ++i) {
            try {
                if (this.dataChunks[i] != null) continue;
                this.dataChunks[i] = this.chunkReader.decodeColumnPage(this, i, null);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.dataChunks;
    }

    public DimensionColumnPage decodeColumnPage(int pageNumber) {
        assert (pageNumber < this.pagesCount);
        if (this.dataChunks == null) {
            this.dataChunks = new DimensionColumnPage[this.pagesCount];
        }
        if (this.dataChunks[pageNumber] == null) {
            try {
                this.dataChunks[pageNumber] = this.chunkReader.decodeColumnPage(this, pageNumber, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.dataChunks[pageNumber];
    }

    public DimensionColumnPage convertToDimColDataChunkWithOutCache(int index, ReusableDataBuffer reusableDataBuffer) {
        assert (index < this.pagesCount);
        if (this.dataChunks != null && null != this.dataChunks[index]) {
            return this.dataChunks[index];
        }
        try {
            return this.chunkReader.decodeColumnPage(this, index, reusableDataBuffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void convertToDimColDataChunkAndFillVector(int pageNumber, ColumnVectorInfo vectorInfo, ReusableDataBuffer reusableDataBuffer) {
        assert (pageNumber < this.pagesCount);
        try {
            this.chunkReader.decodeColumnPageAndFillVector(this, pageNumber, vectorInfo, reusableDataBuffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void freeMemory() {
        super.freeMemory();
        if (null != this.dataChunks) {
            for (int i = 0; i < this.dataChunks.length; ++i) {
                if (this.dataChunks[i] == null) continue;
                this.dataChunks[i].freeMemory();
                this.dataChunks[i] = null;
            }
        }
        this.rawData = null;
    }

    public void setFileReader(FileReader fileReader) {
        this.fileReader = fileReader;
    }

    public FileReader getFileReader() {
        return this.fileReader;
    }

    public CarbonDictionary getLocalDictionary() {
        if (null != this.getDataChunkV3() && null != this.getDataChunkV3().local_dictionary && null == this.localDictionary) {
            try {
                String compressorName = CarbonMetadataUtil.getCompressorNameFromChunkMeta(((DataChunk2)this.getDataChunkV3().data_chunk_list.get((int)0)).chunk_meta);
                Compressor compressor = CompressorFactory.getInstance().getCompressor(compressorName);
                this.localDictionary = DimensionRawColumnChunk.getDictionary(this.getDataChunkV3().local_dictionary, compressor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.localDictionary;
    }

    public static CarbonDictionary getDictionary(LocalDictionaryChunk localDictionaryChunk, Compressor compressor) throws IOException {
        if (null != localDictionaryChunk) {
            List encodings = localDictionaryChunk.getDictionary_meta().getEncoders();
            List encoderMetas = localDictionaryChunk.getDictionary_meta().getEncoder_meta();
            ColumnPageDecoder decoder = DefaultEncodingFactory.getInstance().createDecoder(encodings, encoderMetas, compressor.getName());
            ColumnPage decode = decoder.decode(localDictionaryChunk.getDictionary_data(), 0, localDictionaryChunk.getDictionary_data().length);
            BitSet usedDictionary = BitSet.valueOf(compressor.unCompressByte(localDictionaryChunk.getDictionary_values()));
            int length = usedDictionary.length();
            int index = 0;
            byte[][] dictionary = new byte[length][];
            for (int i = 0; i < length; ++i) {
                dictionary[i] = (byte[])(usedDictionary.get(i) ? decode.getBytes(index++) : null);
            }
            decode.freeMemory();
            if (!usedDictionary.isEmpty()) {
                dictionary[1] = CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
            }
            return new CarbonDictionaryImpl(dictionary, usedDictionary.cardinality());
        }
        return null;
    }
}

