/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.impl;

import org.apache.carbondata.core.datastore.chunk.impl.AbstractDimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.store.DimensionChunkStoreFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;

public class FixedLengthDimensionColumnPage
extends AbstractDimensionColumnPage {
    public FixedLengthDimensionColumnPage(byte[] dataChunk, int[] invertedIndex, int[] invertedIndexReverse, int numberOfRows, int columnValueSize, int dataLength) {
        boolean isExplicitSorted = this.isExplicitSorted(invertedIndex);
        long totalSize = isExplicitSorted ? (long)(dataLength + 2 * numberOfRows * 4) : (long)dataLength;
        this.dataChunkStore = DimensionChunkStoreFactory.INSTANCE.getDimensionChunkStore(columnValueSize, isExplicitSorted, numberOfRows, totalSize, DimensionChunkStoreFactory.DimensionStoreType.FIXED_LENGTH, null, false, dataLength);
        this.dataChunkStore.putArray(invertedIndex, invertedIndexReverse, dataChunk);
    }

    public FixedLengthDimensionColumnPage(byte[] dataChunk, int[] invertedIndex, int[] invertedIndexReverse, int numberOfRows, int columnValueSize, ColumnVectorInfo vectorInfo, int dataLength) {
        boolean isExplicitSorted = this.isExplicitSorted(invertedIndex);
        long totalSize = isExplicitSorted ? (long)(dataLength + 2 * numberOfRows * 4) : (long)dataLength;
        this.dataChunkStore = DimensionChunkStoreFactory.INSTANCE.getDimensionChunkStore(columnValueSize, isExplicitSorted, numberOfRows, totalSize, DimensionChunkStoreFactory.DimensionStoreType.FIXED_LENGTH, null, vectorInfo != null, dataLength);
        if (vectorInfo == null) {
            this.dataChunkStore.putArray(invertedIndex, invertedIndexReverse, dataChunk);
        } else {
            this.dataChunkStore.fillVector(invertedIndex, invertedIndexReverse, dataChunk, vectorInfo);
        }
    }

    @Override
    public int fillRawData(int rowId, int offset, byte[] data) {
        this.dataChunkStore.fillRow(rowId, data, offset);
        return this.dataChunkStore.getColumnValueSize();
    }

    @Override
    public int fillSurrogateKey(int rowId, int chunkIndex, int[] outputSurrogateKey) {
        outputSurrogateKey[chunkIndex] = this.dataChunkStore.getSurrogate(rowId);
        return chunkIndex + 1;
    }

    @Override
    public int fillVector(ColumnVectorInfo[] vectorInfo, int chunkIndex) {
        ColumnVectorInfo columnVectorInfo = vectorInfo[chunkIndex];
        int offset = columnVectorInfo.offset;
        int vectorOffset = columnVectorInfo.vectorOffset;
        int len = columnVectorInfo.size + offset;
        CarbonColumnVector vector = columnVectorInfo.vector;
        for (int j = offset; j < len; ++j) {
            int dict = this.dataChunkStore.getSurrogate(j);
            if (columnVectorInfo.directDictionaryGenerator == null) {
                vector.putInt(vectorOffset++, dict);
                continue;
            }
            Object valueFromSurrogate = columnVectorInfo.directDictionaryGenerator.getValueFromSurrogate(dict);
            if (valueFromSurrogate == null) {
                vector.putNull(vectorOffset++);
                continue;
            }
            DataType dataType = columnVectorInfo.directDictionaryGenerator.getReturnType();
            if (dataType == DataTypes.INT) {
                vector.putInt(vectorOffset++, (Integer)valueFromSurrogate);
                continue;
            }
            if (dataType == DataTypes.LONG) {
                vector.putLong(vectorOffset++, (Long)valueFromSurrogate);
                continue;
            }
            throw new IllegalArgumentException("unsupported data type: " + columnVectorInfo.directDictionaryGenerator.getReturnType());
        }
        return chunkIndex + 1;
    }

    @Override
    public int fillVector(int[] filteredRowId, ColumnVectorInfo[] vectorInfo, int chunkIndex) {
        ColumnVectorInfo columnVectorInfo = vectorInfo[chunkIndex];
        int offset = columnVectorInfo.offset;
        int vectorOffset = columnVectorInfo.vectorOffset;
        int len = columnVectorInfo.size + offset;
        CarbonColumnVector vector = columnVectorInfo.vector;
        for (int j = offset; j < len; ++j) {
            int dict = this.dataChunkStore.getSurrogate(filteredRowId[j]);
            if (columnVectorInfo.directDictionaryGenerator == null) {
                vector.putInt(vectorOffset++, dict);
                continue;
            }
            Object valueFromSurrogate = columnVectorInfo.directDictionaryGenerator.getValueFromSurrogate(dict);
            if (valueFromSurrogate == null) {
                vector.putNull(vectorOffset++);
                continue;
            }
            DataType dataType = columnVectorInfo.directDictionaryGenerator.getReturnType();
            if (dataType == DataTypes.INT) {
                vector.putInt(vectorOffset++, (Integer)valueFromSurrogate);
                continue;
            }
            if (dataType == DataTypes.LONG) {
                vector.putLong(vectorOffset++, (Long)valueFromSurrogate);
                continue;
            }
            throw new IllegalArgumentException("unsupported data type: " + columnVectorInfo.directDictionaryGenerator.getReturnType());
        }
        return chunkIndex + 1;
    }
}

