/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.chunk.AbstractRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.reader.MeasureColumnChunkReader;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;

public class MeasureRawColumnChunk
extends AbstractRawColumnChunk {
    private ColumnPage[] columnPages;
    private MeasureColumnChunkReader chunkReader;
    private FileReader fileReader;

    public MeasureRawColumnChunk(int columnIndex, ByteBuffer rawData, long offSet, int length, MeasureColumnChunkReader chunkReader) {
        super(columnIndex, rawData, offSet, length);
        this.chunkReader = chunkReader;
    }

    public ColumnPage[] decodeAllColumnPages() {
        if (this.columnPages == null) {
            this.columnPages = new ColumnPage[this.pagesCount];
        }
        for (int i = 0; i < this.pagesCount; ++i) {
            try {
                if (this.columnPages[i] != null) continue;
                this.columnPages[i] = this.chunkReader.decodeColumnPage(this, i, null);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.columnPages;
    }

    public ColumnPage decodeColumnPage(int pageNumber) {
        assert (pageNumber < this.pagesCount);
        if (this.columnPages == null) {
            this.columnPages = new ColumnPage[this.pagesCount];
        }
        try {
            if (this.columnPages[pageNumber] == null) {
                this.columnPages[pageNumber] = this.chunkReader.decodeColumnPage(this, pageNumber, null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.columnPages[pageNumber];
    }

    public ColumnPage convertToColumnPageWithOutCache(int index, ReusableDataBuffer reusableDataBuffer) {
        assert (index < this.pagesCount);
        if (null != this.columnPages && this.columnPages[index] != null) {
            return this.columnPages[index];
        }
        try {
            return this.chunkReader.decodeColumnPage(this, index, reusableDataBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void convertToColumnPageAndFillVector(int pageNumber, ColumnVectorInfo vectorInfo, ReusableDataBuffer reusableDataBuffer) {
        assert (pageNumber < this.pagesCount);
        try {
            this.chunkReader.decodeColumnPageAndFillVector(this, pageNumber, vectorInfo, reusableDataBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void freeMemory() {
        super.freeMemory();
        if (null != this.columnPages) {
            for (int i = 0; i < this.columnPages.length; ++i) {
                if (this.columnPages[i] == null) continue;
                this.columnPages[i].freeMemory();
                this.columnPages[i] = null;
            }
        }
        this.rawData = null;
    }

    public void setFileReader(FileReader fileReader) {
        this.fileReader = fileReader;
    }

    public FileReader getFileReader() {
        return this.fileReader;
    }
}

