/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.impl;

import org.apache.carbondata.core.datastore.chunk.impl.AbstractDimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.store.DimensionChunkStoreFactory;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;

public class VariableLengthDimensionColumnPage
extends AbstractDimensionColumnPage {
    public VariableLengthDimensionColumnPage(byte[] dataChunks, int[] invertedIndex, int[] invertedIndexReverse, int numberOfRows, DimensionChunkStoreFactory.DimensionStoreType dimStoreType, CarbonDictionary dictionary, ColumnVectorInfo vectorInfo, int dataLength) {
        boolean isExplicitSorted = this.isExplicitSorted(invertedIndex);
        long totalSize = 0L;
        switch (dimStoreType) {
            case LOCAL_DICT: {
                totalSize = null != invertedIndex ? (long)(dataLength + 2 * numberOfRows * 4) : (long)dataLength;
                break;
            }
            case VARIABLE_INT_LENGTH: 
            case VARIABLE_SHORT_LENGTH: {
                totalSize = null != invertedIndex ? (long)(dataLength + 2 * numberOfRows * 4 + numberOfRows * 4) : (long)(dataLength + numberOfRows * 4);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalidate dimension store type");
            }
        }
        this.dataChunkStore = DimensionChunkStoreFactory.INSTANCE.getDimensionChunkStore(0, isExplicitSorted, numberOfRows, totalSize, dimStoreType, dictionary, vectorInfo != null, dataLength);
        if (vectorInfo != null) {
            this.dataChunkStore.fillVector(invertedIndex, invertedIndexReverse, dataChunks, vectorInfo);
        } else {
            this.dataChunkStore.putArray(invertedIndex, invertedIndexReverse, dataChunks);
        }
    }

    @Override
    public int fillRawData(int rowId, int offset, byte[] data) {
        return 0;
    }

    @Override
    public int fillSurrogateKey(int rowId, int chunkIndex, int[] outputSurrogateKey) {
        return chunkIndex + 1;
    }

    @Override
    public boolean isNoDicitionaryColumn() {
        return true;
    }

    @Override
    public int fillVector(ColumnVectorInfo[] vectorInfo, int chunkIndex) {
        ColumnVectorInfo columnVectorInfo = vectorInfo[chunkIndex];
        CarbonColumnVector vector = columnVectorInfo.vector;
        int offset = columnVectorInfo.offset;
        int vectorOffset = columnVectorInfo.vectorOffset;
        int len = offset + columnVectorInfo.size;
        for (int i = offset; i < len; ++i) {
            this.dataChunkStore.fillRow(i, vector, vectorOffset++);
        }
        return chunkIndex + 1;
    }

    @Override
    public int fillVector(int[] filteredRowId, ColumnVectorInfo[] vectorInfo, int chunkIndex) {
        ColumnVectorInfo columnVectorInfo = vectorInfo[chunkIndex];
        CarbonColumnVector vector = columnVectorInfo.vector;
        int offset = columnVectorInfo.offset;
        int vectorOffset = columnVectorInfo.vectorOffset;
        int len = offset + columnVectorInfo.size;
        for (int i = offset; i < len; ++i) {
            this.dataChunkStore.fillRow(filteredRowId[i], vector, vectorOffset++);
        }
        return chunkIndex + 1;
    }
}

