/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.reader;

import org.apache.carbondata.core.datastore.chunk.reader.DimensionColumnChunkReader;
import org.apache.carbondata.core.datastore.chunk.reader.MeasureColumnChunkReader;
import org.apache.carbondata.core.datastore.chunk.reader.dimension.v3.DimensionChunkPageReaderV3;
import org.apache.carbondata.core.datastore.chunk.reader.dimension.v3.DimensionChunkReaderV3;
import org.apache.carbondata.core.datastore.chunk.reader.measure.v3.MeasureChunkPageReaderV3;
import org.apache.carbondata.core.datastore.chunk.reader.measure.v3.MeasureChunkReaderV3;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;

public class CarbonDataReaderFactory {
    private static final CarbonDataReaderFactory CARBON_DATA_READER_FACTORY = new CarbonDataReaderFactory();

    private CarbonDataReaderFactory() {
    }

    public static CarbonDataReaderFactory getInstance() {
        return CARBON_DATA_READER_FACTORY;
    }

    public DimensionColumnChunkReader getDimensionColumnChunkReader(ColumnarFormatVersion version, BlockletInfo blockletInfo, String filePath, boolean readPagebyPage) {
        switch (version) {
            case V3: {
                if (readPagebyPage) {
                    return new DimensionChunkPageReaderV3(blockletInfo, filePath);
                }
                return new DimensionChunkReaderV3(blockletInfo, filePath);
            }
        }
        throw new UnsupportedOperationException("Unsupported columnar format version: " + (Object)((Object)version));
    }

    public MeasureColumnChunkReader getMeasureColumnChunkReader(ColumnarFormatVersion version, BlockletInfo blockletInfo, String filePath, boolean readPagebyPage) {
        switch (version) {
            case V3: {
                if (readPagebyPage) {
                    return new MeasureChunkPageReaderV3(blockletInfo, filePath);
                }
                return new MeasureChunkReaderV3(blockletInfo, filePath);
            }
        }
        throw new UnsupportedOperationException("Unsupported columnar format version: " + (Object)((Object)version));
    }
}

