/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.reader.dimension;

import java.io.IOException;
import java.util.List;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.reader.DimensionColumnChunkReader;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;

public abstract class AbstractDimensionChunkReader
implements DimensionColumnChunkReader {
    protected Compressor compressor;
    protected String filePath;
    protected List<Long> dimensionChunksOffset;
    protected List<Integer> dimensionChunksLength;

    public AbstractDimensionChunkReader(BlockletInfo blockletInfo, String filePath) {
        this.filePath = filePath;
        this.dimensionChunksOffset = blockletInfo.getDimensionChunkOffsets();
        this.dimensionChunksLength = blockletInfo.getDimensionChunksLength();
    }

    @Override
    public void decodeColumnPageAndFillVector(DimensionRawColumnChunk dimensionRawColumnChunk, int pageNumber, ColumnVectorInfo vectorInfo, ReusableDataBuffer reusableDataBuffer) throws IOException {
        throw new UnsupportedOperationException("This operation is not supported in this reader " + this.getClass().getName());
    }

    @Override
    public DimensionRawColumnChunk[] readRawDimensionChunks(FileReader fileReader, int[][] columnIndexRange) throws IOException {
        DimensionRawColumnChunk[] dataChunks = new DimensionRawColumnChunk[this.dimensionChunksOffset.size()];
        if (columnIndexRange.length == 0) {
            return dataChunks;
        }
        DimensionRawColumnChunk[] groupChunk = null;
        int index = 0;
        for (int i = 0; i < columnIndexRange.length - 1; ++i) {
            index = 0;
            groupChunk = this.readRawDimensionChunksInGroup(fileReader, columnIndexRange[i][0], columnIndexRange[i][1]);
            for (int j = columnIndexRange[i][0]; j <= columnIndexRange[i][1]; ++j) {
                dataChunks[j] = groupChunk[index++];
            }
        }
        if (columnIndexRange[columnIndexRange.length - 1][0] == this.dimensionChunksOffset.size() - 1) {
            dataChunks[columnIndexRange[columnIndexRange.length - 1][0]] = this.readRawDimensionChunk(fileReader, columnIndexRange[columnIndexRange.length - 1][0]);
        } else {
            groupChunk = this.readRawDimensionChunksInGroup(fileReader, columnIndexRange[columnIndexRange.length - 1][0], columnIndexRange[columnIndexRange.length - 1][1]);
            index = 0;
            for (int j = columnIndexRange[columnIndexRange.length - 1][0]; j <= columnIndexRange[columnIndexRange.length - 1][1]; ++j) {
                dataChunks[j] = groupChunk[index++];
            }
        }
        return dataChunks;
    }

    protected abstract DimensionRawColumnChunk[] readRawDimensionChunksInGroup(FileReader var1, int var2, int var3) throws IOException;
}

