/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.reader.dimension.v3;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.reader.dimension.v3.DimensionChunkReaderV3;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.DataChunk3;
import org.apache.carbondata.format.Encoding;

public class DimensionChunkPageReaderV3
extends DimensionChunkReaderV3 {
    private long lastDimensionOffsets;

    public DimensionChunkPageReaderV3(BlockletInfo blockletInfo, String filePath) {
        super(blockletInfo, filePath);
        this.lastDimensionOffsets = blockletInfo.getDimensionOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DimensionRawColumnChunk readRawDimensionChunk(FileReader fileReader, int blockletColumnIndex) throws IOException {
        ByteBuffer buffer;
        long currentDimensionOffset = (Long)this.dimensionChunksOffset.get(blockletColumnIndex);
        int length = 0;
        length = this.dimensionChunksOffset.size() - 1 == blockletColumnIndex ? (int)(this.lastDimensionOffsets - currentDimensionOffset) : (int)((Long)this.dimensionChunksOffset.get(blockletColumnIndex + 1) - currentDimensionOffset);
        FileReader fileReader2 = fileReader;
        synchronized (fileReader2) {
            buffer = fileReader.readByteBuffer(this.filePath, currentDimensionOffset, (Integer)this.dimensionChunksLength.get(blockletColumnIndex));
        }
        DataChunk3 dataChunk = CarbonUtil.readDataChunk3(new ByteArrayInputStream(buffer.array()));
        DimensionRawColumnChunk rawColumnChunk = this.getDimensionRawColumnChunk(fileReader, blockletColumnIndex, currentDimensionOffset, length, null, dataChunk);
        return rawColumnChunk;
    }

    @Override
    protected DimensionRawColumnChunk[] readRawDimensionChunksInGroup(FileReader fileReader, int startBlockletColumnIndex, int endBlockletColumnIndex) throws IOException {
        DimensionRawColumnChunk[] dimensionDataChunks = new DimensionRawColumnChunk[endBlockletColumnIndex - startBlockletColumnIndex + 1];
        int index = 0;
        for (int i = startBlockletColumnIndex; i <= endBlockletColumnIndex; ++i) {
            dimensionDataChunks[index] = this.readRawDimensionChunk(fileReader, i);
            ++index;
        }
        return dimensionDataChunks;
    }

    @Override
    public DimensionColumnPage decodeColumnPage(DimensionRawColumnChunk dimensionRawColumnChunk, int pageNumber, ReusableDataBuffer reusableDataBuffer) throws IOException {
        DataChunk2 pageMetadata = null;
        DataChunk3 dataChunk3 = dimensionRawColumnChunk.getDataChunkV3();
        pageMetadata = (DataChunk2)dataChunk3.getData_chunk_list().get(pageNumber);
        if (this.compressor == null) {
            this.compressor = CompressorFactory.getInstance().getCompressor(CarbonMetadataUtil.getCompressorNameFromChunkMeta(pageMetadata.getChunk_meta()));
        }
        long offset = dimensionRawColumnChunk.getOffSet() + (long)((Integer)this.dimensionChunksLength.get(dimensionRawColumnChunk.getColumnIndex())).intValue() + (long)((Integer)dataChunk3.getPage_offset().get(pageNumber)).intValue();
        int length = pageMetadata.data_page_length;
        if (CarbonUtil.hasEncoding(pageMetadata.encoders, Encoding.INVERTED_INDEX)) {
            length += pageMetadata.rowid_page_length;
        }
        if (CarbonUtil.hasEncoding(pageMetadata.encoders, Encoding.RLE)) {
            length += pageMetadata.rle_page_length;
        }
        ByteBuffer rawData = dimensionRawColumnChunk.getFileReader().readByteBuffer(this.filePath, offset, length);
        return this.decodeDimension(dimensionRawColumnChunk, rawData, pageMetadata, 0, null, reusableDataBuffer);
    }
}

