/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.reader.dimension.v3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.AbstractDimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.FixedLengthDimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.VariableLengthDimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.reader.dimension.AbstractDimensionChunkReader;
import org.apache.carbondata.core.datastore.chunk.store.ColumnPageWrapper;
import org.apache.carbondata.core.datastore.chunk.store.DimensionChunkStoreFactory;
import org.apache.carbondata.core.datastore.columnar.UnBlockIndexer;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageDecoder;
import org.apache.carbondata.core.datastore.page.encoding.DefaultEncodingFactory;
import org.apache.carbondata.core.datastore.page.encoding.EncodingFactory;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.scan.executor.util.QueryUtil;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.DataChunk3;
import org.apache.carbondata.format.Encoding;
import org.apache.commons.lang.ArrayUtils;

public class DimensionChunkReaderV3
extends AbstractDimensionChunkReader {
    private EncodingFactory encodingFactory = DefaultEncodingFactory.getInstance();
    private long lastDimensionOffsets;

    public DimensionChunkReaderV3(BlockletInfo blockletInfo, String filePath) {
        super(blockletInfo, filePath);
        this.lastDimensionOffsets = blockletInfo.getDimensionOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DimensionRawColumnChunk readRawDimensionChunk(FileReader fileReader, int columnIndex) throws IOException {
        long currentDimensionOffset = (Long)this.dimensionChunksOffset.get(columnIndex);
        int length = 0;
        length = this.dimensionChunksOffset.size() - 1 == columnIndex ? (int)(this.lastDimensionOffsets - currentDimensionOffset) : (int)((Long)this.dimensionChunksOffset.get(columnIndex + 1) - currentDimensionOffset);
        ByteBuffer buffer = null;
        FileReader fileReader2 = fileReader;
        synchronized (fileReader2) {
            buffer = fileReader.readByteBuffer(this.filePath, currentDimensionOffset, length);
        }
        DataChunk3 dataChunk = CarbonUtil.readDataChunk3(buffer, 0, length);
        return this.getDimensionRawColumnChunk(fileReader, columnIndex, 0L, length, buffer, dataChunk);
    }

    protected DimensionRawColumnChunk getDimensionRawColumnChunk(FileReader fileReader, int columnIndex, long offset, int length, ByteBuffer buffer, DataChunk3 dataChunk) {
        DimensionRawColumnChunk rawColumnChunk = new DimensionRawColumnChunk(columnIndex, buffer, offset, length, this);
        int numberOfPages = dataChunk.getPage_length().size();
        byte[][] maxValueOfEachPage = new byte[numberOfPages][];
        byte[][] minValueOfEachPage = new byte[numberOfPages][];
        boolean[] minMaxFlag = new boolean[minValueOfEachPage.length];
        Arrays.fill(minMaxFlag, true);
        int[] eachPageLength = new int[numberOfPages];
        for (int i = 0; i < minValueOfEachPage.length; ++i) {
            maxValueOfEachPage[i] = ((ByteBuffer)((DataChunk2)dataChunk.getData_chunk_list().get(i)).getMin_max().getMax_values().get(0)).array();
            minValueOfEachPage[i] = ((ByteBuffer)((DataChunk2)dataChunk.getData_chunk_list().get(i)).getMin_max().getMin_values().get(0)).array();
            eachPageLength[i] = ((DataChunk2)dataChunk.getData_chunk_list().get(i)).getNumberOfRowsInpage();
            boolean isMinMaxFlagSet = ((DataChunk2)dataChunk.getData_chunk_list().get(i)).getMin_max().isSetMin_max_presence();
            if (!isMinMaxFlagSet) continue;
            minMaxFlag[i] = (Boolean)((DataChunk2)dataChunk.getData_chunk_list().get(i)).getMin_max().getMin_max_presence().get(0);
        }
        rawColumnChunk.setDataChunkV3(dataChunk);
        rawColumnChunk.setFileReader(fileReader);
        rawColumnChunk.setPagesCount(dataChunk.getPage_length().size());
        rawColumnChunk.setMaxValues(maxValueOfEachPage);
        rawColumnChunk.setMinValues(minValueOfEachPage);
        rawColumnChunk.setMinMaxFlagArray(minMaxFlag);
        rawColumnChunk.setRowCount(eachPageLength);
        rawColumnChunk.setOffsets(ArrayUtils.toPrimitive((Integer[])dataChunk.page_offset.toArray(new Integer[dataChunk.page_offset.size()])));
        return rawColumnChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DimensionRawColumnChunk[] readRawDimensionChunksInGroup(FileReader fileReader, int startBlockletColumnIndex, int endBlockletColumnIndex) throws IOException {
        long currentDimensionOffset = (Long)this.dimensionChunksOffset.get(startBlockletColumnIndex);
        ByteBuffer buffer = null;
        FileReader fileReader2 = fileReader;
        synchronized (fileReader2) {
            buffer = fileReader.readByteBuffer(this.filePath, currentDimensionOffset, (int)((Long)this.dimensionChunksOffset.get(endBlockletColumnIndex + 1) - currentDimensionOffset));
        }
        DimensionRawColumnChunk[] dimensionDataChunks = new DimensionRawColumnChunk[endBlockletColumnIndex - startBlockletColumnIndex + 1];
        int index = 0;
        int runningLength = 0;
        for (int i = startBlockletColumnIndex; i <= endBlockletColumnIndex; ++i) {
            int currentLength = (int)((Long)this.dimensionChunksOffset.get(i + 1) - (Long)this.dimensionChunksOffset.get(i));
            DataChunk3 dataChunk = CarbonUtil.readDataChunk3(buffer, runningLength, (Integer)this.dimensionChunksLength.get(i));
            dimensionDataChunks[index] = this.getDimensionRawColumnChunk(fileReader, i, runningLength, currentLength, buffer, dataChunk);
            runningLength += currentLength;
            ++index;
        }
        return dimensionDataChunks;
    }

    @Override
    public DimensionColumnPage decodeColumnPage(DimensionRawColumnChunk rawColumnPage, int pageNumber, ReusableDataBuffer reusableDataBuffer) throws IOException {
        return this.decodeColumnPage(rawColumnPage, pageNumber, null, reusableDataBuffer);
    }

    private DimensionColumnPage decodeColumnPage(DimensionRawColumnChunk rawColumnPage, int pageNumber, ColumnVectorInfo vectorInfo, ReusableDataBuffer reusableDataBuffer) throws IOException {
        DataChunk3 dataChunk3 = rawColumnPage.getDataChunkV3();
        ByteBuffer rawData = rawColumnPage.getRawData();
        DataChunk2 pageMetadata = (DataChunk2)dataChunk3.getData_chunk_list().get(pageNumber);
        String compressorName = CarbonMetadataUtil.getCompressorNameFromChunkMeta(pageMetadata.getChunk_meta());
        this.compressor = CompressorFactory.getInstance().getCompressor(compressorName);
        int offset = (int)rawColumnPage.getOffSet() + (Integer)this.dimensionChunksLength.get(rawColumnPage.getColumnIndex()) + (Integer)dataChunk3.getPage_offset().get(pageNumber);
        return this.decodeDimension(rawColumnPage, rawData, pageMetadata, offset, vectorInfo, reusableDataBuffer);
    }

    @Override
    public void decodeColumnPageAndFillVector(DimensionRawColumnChunk dimensionRawColumnChunk, int pageNumber, ColumnVectorInfo vectorInfo, ReusableDataBuffer reusableDataBuffer) throws IOException {
        DimensionColumnPage columnPage = this.decodeColumnPage(dimensionRawColumnChunk, pageNumber, vectorInfo, reusableDataBuffer);
        columnPage.freeMemory();
    }

    private ColumnPage decodeDimensionByMeta(DataChunk2 pageMetadata, ByteBuffer pageData, int offset, boolean isLocalDictEncodedPage, ColumnVectorInfo vectorInfo, BitSet nullBitSet, ReusableDataBuffer reusableDataBuffer) throws IOException {
        List encodings = pageMetadata.getEncoders();
        List encoderMetas = pageMetadata.getEncoder_meta();
        String compressorName = CarbonMetadataUtil.getCompressorNameFromChunkMeta(pageMetadata.getChunk_meta());
        ColumnPageDecoder decoder = this.encodingFactory.createDecoder(encodings, encoderMetas, compressorName, vectorInfo != null);
        if (vectorInfo != null) {
            decoder.decodeAndFillVector(pageData.array(), offset, pageMetadata.data_page_length, vectorInfo, nullBitSet, isLocalDictEncodedPage, pageMetadata.numberOfRowsInpage, reusableDataBuffer);
            return null;
        }
        return decoder.decode(pageData.array(), offset, pageMetadata.data_page_length, isLocalDictEncodedPage);
    }

    protected DimensionColumnPage decodeDimension(DimensionRawColumnChunk rawColumnPage, ByteBuffer pageData, DataChunk2 pageMetadata, int offset, ColumnVectorInfo vectorInfo, ReusableDataBuffer reusableDataBuffer) throws IOException {
        List encodings = pageMetadata.getEncoders();
        org.apache.carbondata.core.metadata.encoder.Encoding.validateEncodingTypes(encodings);
        if (CarbonUtil.isEncodedWithMeta(encodings)) {
            int[] invertedIndexes = new int[]{};
            int[] invertedIndexesReverse = new int[]{};
            boolean isExplicitSorted = CarbonUtil.hasEncoding(pageMetadata.encoders, Encoding.INVERTED_INDEX);
            int dataOffset = offset;
            if (isExplicitSorted) {
                invertedIndexes = CarbonUtil.getUnCompressColumnIndex(pageMetadata.rowid_page_length, pageData, offset += pageMetadata.data_page_length);
                if (vectorInfo == null) {
                    invertedIndexesReverse = CarbonUtil.getInvertedReverseIndex(invertedIndexes);
                } else {
                    vectorInfo.invertedIndex = invertedIndexes;
                }
            }
            BitSet nullBitSet = QueryUtil.getNullBitSet(pageMetadata.presence, this.compressor);
            ColumnPage decodedPage = this.decodeDimensionByMeta(pageMetadata, pageData, dataOffset, null != rawColumnPage.getLocalDictionary(), vectorInfo, nullBitSet, reusableDataBuffer);
            if (decodedPage != null) {
                decodedPage.setNullBits(nullBitSet);
            }
            return new ColumnPageWrapper(decodedPage, rawColumnPage.getLocalDictionary(), invertedIndexes, invertedIndexesReverse, this.isEncodedWithAdaptiveMeta(pageMetadata), isExplicitSorted);
        }
        return this.decodeDimensionLegacy(rawColumnPage, pageData, pageMetadata, offset, vectorInfo, reusableDataBuffer);
    }

    public boolean isEncodedWithAdaptiveMeta(DataChunk2 pageMetadata) {
        List encodings = pageMetadata.getEncoders();
        if (encodings != null && !encodings.isEmpty()) {
            Encoding encoding = (Encoding)encodings.get(0);
            switch (encoding) {
                case ADAPTIVE_INTEGRAL: 
                case ADAPTIVE_DELTA_INTEGRAL: 
                case ADAPTIVE_FLOATING: 
                case ADAPTIVE_DELTA_FLOATING: {
                    return true;
                }
            }
        }
        return false;
    }

    private int getColumnValueSize(List<Encoding> encodings) {
        return encodings.contains(Encoding.DICTIONARY) ? 4 : -1;
    }

    private DimensionColumnPage decodeDimensionLegacy(DimensionRawColumnChunk rawColumnPage, ByteBuffer pageData, DataChunk2 pageMetadata, int offset, ColumnVectorInfo vectorInfo, ReusableDataBuffer reusableDataBuffer) {
        byte[] dataPage;
        int[] invertedIndexes = new int[]{};
        int[] invertedIndexesReverse = new int[]{};
        int uncompressedSize = 0;
        if (null != reusableDataBuffer && this.compressor.supportReusableBuffer()) {
            uncompressedSize = this.compressor.unCompressedLength(pageData.array(), offset, pageMetadata.data_page_length);
            dataPage = reusableDataBuffer.getDataBuffer(uncompressedSize);
            this.compressor.rawUncompress(pageData.array(), offset, pageMetadata.data_page_length, dataPage);
        } else {
            dataPage = this.compressor.unCompressByte(pageData.array(), offset, pageMetadata.data_page_length);
            uncompressedSize = dataPage.length;
        }
        offset += pageMetadata.data_page_length;
        if (CarbonUtil.hasEncoding(pageMetadata.encoders, Encoding.INVERTED_INDEX)) {
            invertedIndexes = CarbonUtil.getUnCompressColumnIndex(pageMetadata.rowid_page_length, pageData, offset);
            offset += pageMetadata.rowid_page_length;
            if (vectorInfo == null) {
                invertedIndexesReverse = CarbonUtil.getInvertedReverseIndex(invertedIndexes);
            }
        }
        if (CarbonUtil.hasEncoding(pageMetadata.encoders, Encoding.RLE)) {
            int[] rlePage = CarbonUtil.getIntArray(pageData, offset, pageMetadata.rle_page_length);
            dataPage = UnBlockIndexer.uncompressData(dataPage, rlePage, null == rawColumnPage.getLocalDictionary() ? this.getColumnValueSize(pageMetadata.encoders) : 3, uncompressedSize);
            uncompressedSize = dataPage.length;
        }
        AbstractDimensionColumnPage columnDataChunk = null;
        if (!CarbonUtil.hasEncoding(pageMetadata.encoders, Encoding.DICTIONARY)) {
            DimensionChunkStoreFactory.DimensionStoreType dimStoreType = null != rawColumnPage.getLocalDictionary() ? DimensionChunkStoreFactory.DimensionStoreType.LOCAL_DICT : (CarbonUtil.hasEncoding(pageMetadata.encoders, Encoding.DIRECT_COMPRESS_VARCHAR) ? DimensionChunkStoreFactory.DimensionStoreType.VARIABLE_INT_LENGTH : DimensionChunkStoreFactory.DimensionStoreType.VARIABLE_SHORT_LENGTH);
            columnDataChunk = new VariableLengthDimensionColumnPage(dataPage, invertedIndexes, invertedIndexesReverse, pageMetadata.getNumberOfRowsInpage(), dimStoreType, rawColumnPage.getLocalDictionary(), vectorInfo, uncompressedSize);
        } else {
            columnDataChunk = new FixedLengthDimensionColumnPage(dataPage, invertedIndexes, invertedIndexesReverse, pageMetadata.getNumberOfRowsInpage(), this.getColumnValueSize(pageMetadata.encoders), vectorInfo, uncompressedSize);
        }
        return columnDataChunk;
    }
}

