/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.reader.measure;

import java.io.IOException;
import java.util.List;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.reader.MeasureColumnChunkReader;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.page.encoding.DefaultEncodingFactory;
import org.apache.carbondata.core.datastore.page.encoding.EncodingFactory;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;

public abstract class AbstractMeasureChunkReader
implements MeasureColumnChunkReader {
    protected Compressor compressor;
    protected EncodingFactory encodingFactory = DefaultEncodingFactory.getInstance();
    protected String filePath;
    protected List<Long> measureColumnChunkOffsets;
    protected List<Integer> measureColumnChunkLength;

    public AbstractMeasureChunkReader(BlockletInfo blockletInfo, String filePath) {
        this.filePath = filePath;
        this.measureColumnChunkOffsets = blockletInfo.getMeasureChunkOffsets();
        this.measureColumnChunkLength = blockletInfo.getMeasureChunksLength();
    }

    @Override
    public MeasureRawColumnChunk[] readRawMeasureChunks(FileReader fileReader, int[][] columnIndexRange) throws IOException {
        MeasureRawColumnChunk[] dataChunks = new MeasureRawColumnChunk[this.measureColumnChunkOffsets.size()];
        if (columnIndexRange.length == 0) {
            return dataChunks;
        }
        MeasureRawColumnChunk[] groupChunk = null;
        int index = 0;
        for (int i = 0; i < columnIndexRange.length - 1; ++i) {
            index = 0;
            groupChunk = this.readRawMeasureChunksInGroup(fileReader, columnIndexRange[i][0], columnIndexRange[i][1]);
            for (int j = columnIndexRange[i][0]; j <= columnIndexRange[i][1]; ++j) {
                dataChunks[j] = groupChunk[index++];
            }
        }
        if (columnIndexRange[columnIndexRange.length - 1][0] == this.measureColumnChunkOffsets.size() - 1) {
            dataChunks[columnIndexRange[columnIndexRange.length - 1][0]] = this.readRawMeasureChunk(fileReader, columnIndexRange[columnIndexRange.length - 1][0]);
        } else {
            groupChunk = this.readRawMeasureChunksInGroup(fileReader, columnIndexRange[columnIndexRange.length - 1][0], columnIndexRange[columnIndexRange.length - 1][1]);
            index = 0;
            for (int j = columnIndexRange[columnIndexRange.length - 1][0]; j <= columnIndexRange[columnIndexRange.length - 1][1]; ++j) {
                dataChunks[j] = groupChunk[index++];
            }
        }
        return dataChunks;
    }

    protected abstract MeasureRawColumnChunk[] readRawMeasureChunksInGroup(FileReader var1, int var2, int var3) throws IOException;
}

