/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.reader.measure.v3;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.reader.measure.v3.MeasureChunkReaderV3;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.scan.executor.util.QueryUtil;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.DataChunk3;

public class MeasureChunkPageReaderV3
extends MeasureChunkReaderV3 {
    private long measureOffsets;

    public MeasureChunkPageReaderV3(BlockletInfo blockletInfo, String filePath) {
        super(blockletInfo, filePath);
        this.measureOffsets = blockletInfo.getMeasureOffsets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeasureRawColumnChunk readRawMeasureChunk(FileReader fileReader, int blockletColumnIndex) throws IOException {
        ByteBuffer buffer;
        int dataLength = 0;
        dataLength = this.measureColumnChunkOffsets.size() - 1 == blockletColumnIndex ? (int)(this.measureOffsets - (Long)this.measureColumnChunkOffsets.get(blockletColumnIndex)) : (int)((Long)this.measureColumnChunkOffsets.get(blockletColumnIndex + 1) - (Long)this.measureColumnChunkOffsets.get(blockletColumnIndex));
        FileReader fileReader2 = fileReader;
        synchronized (fileReader2) {
            buffer = fileReader.readByteBuffer(this.filePath, (Long)this.measureColumnChunkOffsets.get(blockletColumnIndex), (Integer)this.measureColumnChunkLength.get(blockletColumnIndex));
        }
        DataChunk3 dataChunk = CarbonUtil.readDataChunk3(new ByteArrayInputStream(buffer.array()));
        return this.getMeasureRawColumnChunk(fileReader, blockletColumnIndex, (Long)this.measureColumnChunkOffsets.get(blockletColumnIndex), dataLength, null, dataChunk);
    }

    @Override
    protected MeasureRawColumnChunk[] readRawMeasureChunksInGroup(FileReader fileReader, int startColumnBlockletIndex, int endColumnBlockletIndex) throws IOException {
        MeasureRawColumnChunk[] measureDataChunk = new MeasureRawColumnChunk[endColumnBlockletIndex - startColumnBlockletIndex + 1];
        int index = 0;
        for (int i = startColumnBlockletIndex; i <= endColumnBlockletIndex; ++i) {
            measureDataChunk[index] = this.readRawMeasureChunk(fileReader, i);
            ++index;
        }
        return measureDataChunk;
    }

    @Override
    public ColumnPage decodeColumnPage(MeasureRawColumnChunk rawColumnPage, int pageNumber, ReusableDataBuffer reusableDataBuffer) throws IOException {
        DataChunk3 dataChunk3 = rawColumnPage.getDataChunkV3();
        DataChunk2 pageMetadata = (DataChunk2)dataChunk3.getData_chunk_list().get(pageNumber);
        String compressorName = CarbonMetadataUtil.getCompressorNameFromChunkMeta(pageMetadata.getChunk_meta());
        this.compressor = CompressorFactory.getInstance().getCompressor(compressorName);
        long offset = rawColumnPage.getOffSet() + (long)((Integer)this.measureColumnChunkLength.get(rawColumnPage.getColumnIndex())).intValue() + (long)((Integer)dataChunk3.getPage_offset().get(pageNumber)).intValue();
        ByteBuffer buffer = rawColumnPage.getFileReader().readByteBuffer(this.filePath, offset, pageMetadata.data_page_length);
        BitSet nullBitSet = QueryUtil.getNullBitSet(pageMetadata.presence, this.compressor);
        ColumnPage decodedPage = this.decodeMeasure(pageMetadata, buffer, 0, null, nullBitSet, reusableDataBuffer);
        decodedPage.setNullBits(nullBitSet);
        return decodedPage;
    }
}

