/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.reader.measure.v3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.reader.measure.AbstractMeasureChunkReader;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageDecoder;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.scan.executor.util.QueryUtil;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.DataChunk3;
import org.apache.commons.lang.ArrayUtils;

public class MeasureChunkReaderV3
extends AbstractMeasureChunkReader {
    private long measureOffsets;

    public MeasureChunkReaderV3(BlockletInfo blockletInfo, String filePath) {
        super(blockletInfo, filePath);
        this.measureOffsets = blockletInfo.getMeasureOffsets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeasureRawColumnChunk readRawMeasureChunk(FileReader fileReader, int columnIndex) throws IOException {
        int dataLength = 0;
        dataLength = this.measureColumnChunkOffsets.size() - 1 == columnIndex ? (int)(this.measureOffsets - (Long)this.measureColumnChunkOffsets.get(columnIndex)) : (int)((Long)this.measureColumnChunkOffsets.get(columnIndex + 1) - (Long)this.measureColumnChunkOffsets.get(columnIndex));
        ByteBuffer buffer = null;
        FileReader fileReader2 = fileReader;
        synchronized (fileReader2) {
            buffer = fileReader.readByteBuffer(this.filePath, (Long)this.measureColumnChunkOffsets.get(columnIndex), dataLength);
        }
        DataChunk3 dataChunk = CarbonUtil.readDataChunk3(buffer, 0, (Integer)this.measureColumnChunkLength.get(columnIndex));
        return this.getMeasureRawColumnChunk(fileReader, columnIndex, 0L, dataLength, buffer, dataChunk);
    }

    MeasureRawColumnChunk getMeasureRawColumnChunk(FileReader fileReader, int columnIndex, long offset, int dataLength, ByteBuffer buffer, DataChunk3 dataChunk) {
        MeasureRawColumnChunk rawColumnChunk = new MeasureRawColumnChunk(columnIndex, buffer, offset, dataLength, this);
        int numberOfPages = dataChunk.getPage_length().size();
        byte[][] maxValueOfEachPage = new byte[numberOfPages][];
        byte[][] minValueOfEachPage = new byte[numberOfPages][];
        int[] eachPageLength = new int[numberOfPages];
        for (int i = 0; i < minValueOfEachPage.length; ++i) {
            maxValueOfEachPage[i] = ((ByteBuffer)((DataChunk2)dataChunk.getData_chunk_list().get(i)).getMin_max().getMax_values().get(0)).array();
            minValueOfEachPage[i] = ((ByteBuffer)((DataChunk2)dataChunk.getData_chunk_list().get(i)).getMin_max().getMin_values().get(0)).array();
            eachPageLength[i] = ((DataChunk2)dataChunk.getData_chunk_list().get(i)).getNumberOfRowsInpage();
        }
        rawColumnChunk.setDataChunkV3(dataChunk);
        rawColumnChunk.setFileReader(fileReader);
        rawColumnChunk.setPagesCount(dataChunk.getPage_length().size());
        rawColumnChunk.setMaxValues(maxValueOfEachPage);
        rawColumnChunk.setMinValues(minValueOfEachPage);
        rawColumnChunk.setRowCount(eachPageLength);
        rawColumnChunk.setOffsets(ArrayUtils.toPrimitive((Integer[])dataChunk.page_offset.toArray(new Integer[dataChunk.page_offset.size()])));
        return rawColumnChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MeasureRawColumnChunk[] readRawMeasureChunksInGroup(FileReader fileReader, int startColumnIndex, int endColumnIndex) throws IOException {
        long currentMeasureOffset = (Long)this.measureColumnChunkOffsets.get(startColumnIndex);
        ByteBuffer buffer = null;
        FileReader fileReader2 = fileReader;
        synchronized (fileReader2) {
            buffer = fileReader.readByteBuffer(this.filePath, currentMeasureOffset, (int)((Long)this.measureColumnChunkOffsets.get(endColumnIndex + 1) - currentMeasureOffset));
        }
        MeasureRawColumnChunk[] measureDataChunk = new MeasureRawColumnChunk[endColumnIndex - startColumnIndex + 1];
        int runningLength = 0;
        int index = 0;
        for (int i = startColumnIndex; i <= endColumnIndex; ++i) {
            MeasureRawColumnChunk measureRawColumnChunk;
            int currentLength = (int)((Long)this.measureColumnChunkOffsets.get(i + 1) - (Long)this.measureColumnChunkOffsets.get(i));
            DataChunk3 dataChunk = CarbonUtil.readDataChunk3(buffer, runningLength, (Integer)this.measureColumnChunkLength.get(i));
            measureDataChunk[index] = measureRawColumnChunk = this.getMeasureRawColumnChunk(fileReader, i, runningLength, currentLength, buffer, dataChunk);
            runningLength += currentLength;
            ++index;
        }
        return measureDataChunk;
    }

    @Override
    public ColumnPage decodeColumnPage(MeasureRawColumnChunk rawColumnChunk, int pageNumber, ReusableDataBuffer reusableDataBuffer) throws IOException {
        return this.decodeColumnPage(rawColumnChunk, pageNumber, null, reusableDataBuffer);
    }

    @Override
    public void decodeColumnPageAndFillVector(MeasureRawColumnChunk measureRawColumnChunk, int pageNumber, ColumnVectorInfo vectorInfo, ReusableDataBuffer reusableDataBuffer) throws IOException {
        this.decodeColumnPage(measureRawColumnChunk, pageNumber, vectorInfo, reusableDataBuffer);
    }

    private ColumnPage decodeColumnPage(MeasureRawColumnChunk rawColumnChunk, int pageNumber, ColumnVectorInfo vectorInfo, ReusableDataBuffer reusableDataBuffer) throws IOException {
        DataChunk3 dataChunk3 = rawColumnChunk.getDataChunkV3();
        DataChunk2 pageMetadata = (DataChunk2)dataChunk3.getData_chunk_list().get(pageNumber);
        String compressorName = CarbonMetadataUtil.getCompressorNameFromChunkMeta(pageMetadata.getChunk_meta());
        this.compressor = CompressorFactory.getInstance().getCompressor(compressorName);
        int offset = (int)rawColumnChunk.getOffSet() + (Integer)this.measureColumnChunkLength.get(rawColumnChunk.getColumnIndex()) + (Integer)dataChunk3.getPage_offset().get(pageNumber);
        BitSet nullBitSet = QueryUtil.getNullBitSet(pageMetadata.presence, this.compressor);
        ColumnPage decodedPage = this.decodeMeasure(pageMetadata, rawColumnChunk.getRawData(), offset, vectorInfo, nullBitSet, reusableDataBuffer);
        if (decodedPage == null) {
            return null;
        }
        decodedPage.setNullBits(nullBitSet);
        return decodedPage;
    }

    protected ColumnPage decodeMeasure(DataChunk2 pageMetadata, ByteBuffer pageData, int offset, ColumnVectorInfo vectorInfo, BitSet nullBitSet, ReusableDataBuffer reusableDataBuffer) throws IOException {
        List encodings = pageMetadata.getEncoders();
        Encoding.validateEncodingTypes(encodings);
        List encoderMetas = pageMetadata.getEncoder_meta();
        String compressorName = CarbonMetadataUtil.getCompressorNameFromChunkMeta(pageMetadata.getChunk_meta());
        ColumnPageDecoder codec = this.encodingFactory.createDecoder(encodings, encoderMetas, compressorName, vectorInfo != null);
        if (vectorInfo != null) {
            codec.decodeAndFillVector(pageData.array(), offset, pageMetadata.data_page_length, vectorInfo, nullBitSet, false, pageMetadata.numberOfRowsInpage, reusableDataBuffer);
            return null;
        }
        return codec.decode(pageData.array(), offset, pageMetadata.data_page_length);
    }
}

