/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store;

import java.util.BitSet;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;

public class ColumnPageWrapper
implements DimensionColumnPage {
    private ColumnPage columnPage;
    private CarbonDictionary localDictionary;
    private boolean isAdaptivePrimitivePage;
    private int[] invertedIndex;
    private int[] invertedReverseIndex;
    private boolean isExplicitSorted;

    public ColumnPageWrapper(ColumnPage columnPage, CarbonDictionary localDictionary, int[] invertedIndex, int[] invertedReverseIndex, boolean isAdaptivePrimitivePage, boolean isExplicitSorted) {
        this.columnPage = columnPage;
        this.localDictionary = localDictionary;
        this.invertedIndex = invertedIndex;
        this.invertedReverseIndex = invertedReverseIndex;
        this.isAdaptivePrimitivePage = isAdaptivePrimitivePage;
        this.isExplicitSorted = isExplicitSorted;
    }

    @Override
    public int fillRawData(int rowId, int offset, byte[] data) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public int fillSurrogateKey(int rowId, int chunkIndex, int[] outputSurrogateKey) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public int fillVector(ColumnVectorInfo[] vectorInfo, int chunkIndex) {
        ColumnVectorInfo columnVectorInfo = vectorInfo[chunkIndex];
        CarbonColumnVector vector = columnVectorInfo.vector;
        int offset = columnVectorInfo.offset;
        int vectorOffset = columnVectorInfo.vectorOffset;
        int len = offset + columnVectorInfo.size;
        for (int i = offset; i < len; ++i) {
            this.fillRow(i, vector, vectorOffset++);
        }
        return chunkIndex + 1;
    }

    @Override
    public int fillVector(int[] filteredRowId, ColumnVectorInfo[] vectorInfo, int chunkIndex) {
        ColumnVectorInfo columnVectorInfo = vectorInfo[chunkIndex];
        CarbonColumnVector vector = columnVectorInfo.vector;
        int offset = columnVectorInfo.offset;
        int vectorOffset = columnVectorInfo.vectorOffset;
        int len = offset + columnVectorInfo.size;
        for (int i = offset; i < len; ++i) {
            this.fillRow(filteredRowId[i], vector, vectorOffset++);
        }
        return chunkIndex + 1;
    }

    @Override
    public byte[] getChunkData(int rowId) {
        byte[] nullBitSet = this.getNullBitSet(rowId, this.columnPage.getColumnSpec().getColumnType());
        if (nullBitSet != null) {
            return nullBitSet;
        }
        if (this.isExplicitSorted()) {
            rowId = this.getInvertedReverseIndex(rowId);
        }
        return this.getChunkDataInBytes(rowId);
    }

    private byte[] getChunkDataInBytes(int rowId) {
        ColumnType columnType = this.columnPage.getColumnSpec().getColumnType();
        DataType srcDataType = this.columnPage.getColumnSpec().getSchemaDataType();
        DataType targetDataType = this.columnPage.getDataType();
        if (null != this.localDictionary) {
            return this.localDictionary.getDictionaryValue(CarbonUtil.getSurrogateInternal(this.columnPage.getBytes(rowId), 0, 3));
        }
        if (columnType == ColumnType.COMPLEX_PRIMITIVE && this.isAdaptiveEncoded() || columnType == ColumnType.PLAIN_VALUE && DataTypeUtil.isPrimitiveColumn(srcDataType)) {
            if (srcDataType == DataTypes.FLOAT) {
                float floatData = this.columnPage.getFloat(rowId);
                return ByteUtil.toXorBytes(floatData);
            }
            if (srcDataType == DataTypes.DOUBLE) {
                double doubleData = this.columnPage.getDouble(rowId);
                return ByteUtil.toXorBytes(doubleData);
            }
            if (DataTypes.isDecimal(srcDataType)) {
                throw new RuntimeException("unsupported type: " + srcDataType);
            }
            if (srcDataType == DataTypes.BYTE || srcDataType == DataTypes.BOOLEAN || srcDataType == DataTypes.SHORT || srcDataType == DataTypes.SHORT_INT || srcDataType == DataTypes.INT || srcDataType == DataTypes.LONG || srcDataType == DataTypes.TIMESTAMP) {
                long longData = this.columnPage.getLong(rowId);
                if (srcDataType == DataTypes.BYTE) {
                    byte out = (byte)longData;
                    return new byte[]{out};
                }
                if (srcDataType == DataTypes.BOOLEAN) {
                    byte out = (byte)longData;
                    return ByteUtil.toBytes(ByteUtil.toBoolean(out));
                }
                if (srcDataType == DataTypes.SHORT) {
                    short out = (short)longData;
                    return ByteUtil.toXorBytes(out);
                }
                if (srcDataType == DataTypes.SHORT_INT) {
                    int out = (int)longData;
                    return ByteUtil.toXorBytes(out);
                }
                if (srcDataType == DataTypes.INT) {
                    int out = (int)longData;
                    return ByteUtil.toXorBytes(out);
                }
                return ByteUtil.toXorBytes(longData);
            }
            if (targetDataType == DataTypes.STRING || targetDataType == DataTypes.VARCHAR || targetDataType == DataTypes.BYTE_ARRAY) {
                return this.columnPage.getBytes(rowId);
            }
            throw new RuntimeException("unsupported type: " + targetDataType);
        }
        if (columnType == ColumnType.COMPLEX_PRIMITIVE && !this.isAdaptiveEncoded()) {
            if (srcDataType == DataTypes.BYTE || srcDataType == DataTypes.BOOLEAN) {
                byte[] out = new byte[]{this.columnPage.getByte(rowId)};
                return ByteUtil.toBytes(ByteUtil.toBoolean(out));
            }
            if (srcDataType == DataTypes.BYTE_ARRAY) {
                return this.columnPage.getBytes(rowId);
            }
            if (srcDataType == DataTypes.DOUBLE) {
                return ByteUtil.toXorBytes(this.columnPage.getDouble(rowId));
            }
            if (srcDataType == DataTypes.FLOAT) {
                return ByteUtil.toXorBytes(this.columnPage.getFloat(rowId));
            }
            if (srcDataType == targetDataType) {
                return this.columnPage.getBytes(rowId);
            }
            throw new RuntimeException("unsupported type: " + targetDataType);
        }
        return this.columnPage.getBytes(rowId);
    }

    private byte[] getNullBitSet(int rowId, ColumnType columnType) {
        if (this.columnPage.getNullBits().get(rowId) && columnType == ColumnType.COMPLEX_PRIMITIVE) {
            return CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
        }
        if (this.columnPage.getNullBits().get(rowId)) {
            return CarbonCommonConstants.EMPTY_BYTE_ARRAY;
        }
        return null;
    }

    private void fillRow(int rowId, CarbonColumnVector vector, int vectorRow) {
        if (this.columnPage.getNullBits().get(rowId)) {
            vector.putNull(vectorRow);
        } else {
            if (this.isExplicitSorted) {
                rowId = this.invertedReverseIndex[rowId];
            }
            DataType dt = vector.getType();
            long longData = this.columnPage.getLong(rowId);
            if (dt == DataTypes.BOOLEAN) {
                vector.putBoolean(vectorRow, ByteUtil.toBoolean((byte)longData));
            } else if (dt == DataTypes.BYTE) {
                vector.putByte(vectorRow, (byte)longData);
            } else if (dt == DataTypes.SHORT) {
                vector.putShort(vectorRow, (short)longData);
            } else if (dt == DataTypes.INT) {
                vector.putInt(vectorRow, (int)longData);
            } else if (dt == DataTypes.LONG) {
                if (vector.getBlockDataType() == DataTypes.INT) {
                    vector.putLong(vectorRow, (int)longData);
                } else if (vector.getBlockDataType() == DataTypes.LONG) {
                    vector.putLong(vectorRow, longData);
                }
            } else if (dt == DataTypes.TIMESTAMP) {
                vector.putLong(vectorRow, longData * 1000L);
            } else {
                throw new RuntimeException("unsupported type: " + dt);
            }
        }
    }

    @Override
    public int getInvertedIndex(int rowId) {
        return this.invertedIndex[rowId];
    }

    @Override
    public int getInvertedReverseIndex(int rowId) {
        return this.invertedReverseIndex[rowId];
    }

    @Override
    public boolean isNoDicitionaryColumn() {
        return true;
    }

    @Override
    public boolean isExplicitSorted() {
        return this.isExplicitSorted;
    }

    @Override
    public int compareTo(int rowId, byte[] compareValue) {
        byte[] nullBitSet;
        int nullBitSetRowId = rowId;
        if (this.isExplicitSorted()) {
            nullBitSetRowId = this.getInvertedIndex(rowId);
        }
        if ((nullBitSet = this.getNullBitSet(nullBitSetRowId, this.columnPage.getColumnSpec().getColumnType())) != null && ByteUtil.UnsafeComparer.INSTANCE.compareTo(nullBitSet, compareValue) == 0) {
            return 0;
        }
        byte[] chunkData = nullBitSet != null && nullBitSet.length == 0 ? nullBitSet : this.getChunkDataInBytes(rowId);
        return ByteUtil.UnsafeComparer.INSTANCE.compareTo(chunkData, compareValue);
    }

    @Override
    public void freeMemory() {
        if (null != this.columnPage) {
            this.columnPage.freeMemory();
            this.columnPage = null;
        }
    }

    @Override
    public boolean isAdaptiveEncoded() {
        return this.isAdaptivePrimitivePage;
    }

    @Override
    public BitSet getNullBits() {
        return this.columnPage.getNullBits();
    }
}

