/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store;

import org.apache.carbondata.core.datastore.chunk.store.DimensionDataChunkStore;
import org.apache.carbondata.core.datastore.chunk.store.impl.LocalDictDimensionDataChunkStore;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.SafeFixedLengthDimensionDataChunkStore;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.SafeVariableIntLengthDimensionDataChunkStore;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.SafeVariableShortLengthDimensionDataChunkStore;
import org.apache.carbondata.core.datastore.chunk.store.impl.unsafe.UnsafeFixedLengthDimensionDataChunkStore;
import org.apache.carbondata.core.datastore.chunk.store.impl.unsafe.UnsafeVariableIntLengthDimensionDataChunkStore;
import org.apache.carbondata.core.datastore.chunk.store.impl.unsafe.UnsafeVariableShortLengthDimensionDataChunkStore;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.util.CarbonProperties;

public class DimensionChunkStoreFactory {
    public static final DimensionChunkStoreFactory INSTANCE = new DimensionChunkStoreFactory();
    private static final boolean isUnsafe = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("enable.unsafe.in.query.processing", "false"));

    private DimensionChunkStoreFactory() {
    }

    public DimensionDataChunkStore getDimensionChunkStore(int columnValueSize, boolean isInvertedIndex, int numberOfRows, long totalSize, DimensionStoreType storeType, CarbonDictionary dictionary, boolean fillDirectVector, int dataLength) {
        if (isUnsafe && !fillDirectVector) {
            switch (storeType) {
                case FIXED_LENGTH: {
                    return new UnsafeFixedLengthDimensionDataChunkStore(totalSize, columnValueSize, isInvertedIndex, numberOfRows, dataLength);
                }
                case VARIABLE_SHORT_LENGTH: {
                    return new UnsafeVariableShortLengthDimensionDataChunkStore(totalSize, isInvertedIndex, numberOfRows, dataLength);
                }
                case VARIABLE_INT_LENGTH: {
                    return new UnsafeVariableIntLengthDimensionDataChunkStore(totalSize, isInvertedIndex, numberOfRows, dataLength);
                }
                case LOCAL_DICT: {
                    return new LocalDictDimensionDataChunkStore(new UnsafeFixedLengthDimensionDataChunkStore(totalSize, 3, isInvertedIndex, numberOfRows, dataLength), dictionary, dataLength);
                }
            }
            throw new UnsupportedOperationException("Invalid dimension store type");
        }
        switch (storeType) {
            case FIXED_LENGTH: {
                return new SafeFixedLengthDimensionDataChunkStore(isInvertedIndex, columnValueSize, numberOfRows);
            }
            case VARIABLE_SHORT_LENGTH: {
                return new SafeVariableShortLengthDimensionDataChunkStore(isInvertedIndex, numberOfRows, dataLength);
            }
            case VARIABLE_INT_LENGTH: {
                return new SafeVariableIntLengthDimensionDataChunkStore(isInvertedIndex, numberOfRows, dataLength);
            }
            case LOCAL_DICT: {
                return new LocalDictDimensionDataChunkStore(new SafeFixedLengthDimensionDataChunkStore(isInvertedIndex, 3, numberOfRows), dictionary, dataLength);
            }
        }
        throw new UnsupportedOperationException("Invalid dimension store type");
    }

    public static enum DimensionStoreType {
        FIXED_LENGTH,
        VARIABLE_SHORT_LENGTH,
        VARIABLE_INT_LENGTH,
        LOCAL_DICT;

    }
}

