/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store.impl;

import java.util.BitSet;
import org.apache.carbondata.core.datastore.chunk.store.DimensionDataChunkStore;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ColumnarVectorWrapperDirectFactory;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ConvertableVector;
import org.apache.carbondata.core.util.CarbonUtil;

public class LocalDictDimensionDataChunkStore
implements DimensionDataChunkStore {
    private DimensionDataChunkStore dimensionDataChunkStore;
    private CarbonDictionary dictionary;
    private int dataLength;

    public LocalDictDimensionDataChunkStore(DimensionDataChunkStore dimensionDataChunkStore, CarbonDictionary dictionary, int dataLength) {
        this.dimensionDataChunkStore = dimensionDataChunkStore;
        this.dictionary = dictionary;
        this.dataLength = dataLength;
    }

    @Override
    public void putArray(int[] invertedIndex, int[] invertedIndexReverse, byte[] data) {
        this.dimensionDataChunkStore.putArray(invertedIndex, invertedIndexReverse, data);
    }

    @Override
    public void fillVector(int[] invertedIndex, int[] invertedIndexReverse, byte[] data, ColumnVectorInfo vectorInfo) {
        int columnValueSize = this.dimensionDataChunkStore.getColumnValueSize();
        int rowsNum = this.dataLength / columnValueSize;
        CarbonColumnVector vector = vectorInfo.vector;
        if (!this.dictionary.isDictionaryUsed()) {
            vector.setDictionary(this.dictionary);
            this.dictionary.setDictionaryUsed();
        }
        BitSet nullBitset = new BitSet();
        CarbonColumnVector dictionaryVector = ColumnarVectorWrapperDirectFactory.getDirectVectorWrapperFactory(vector.getDictionaryVector(), invertedIndex, nullBitset, vectorInfo.deletedRows, false, true);
        vector = ColumnarVectorWrapperDirectFactory.getDirectVectorWrapperFactory(vector, invertedIndex, nullBitset, vectorInfo.deletedRows, false, false);
        for (int i = 0; i < rowsNum; ++i) {
            int surrogate = CarbonUtil.getSurrogateInternal(data, i * columnValueSize, columnValueSize);
            if (surrogate == 1) {
                vector.putNull(i);
                dictionaryVector.putNull(i);
                continue;
            }
            vector.putNotNull(i);
            dictionaryVector.putInt(i, surrogate);
        }
        if (dictionaryVector instanceof ConvertableVector) {
            ((ConvertableVector)((Object)dictionaryVector)).convert();
        }
    }

    @Override
    public byte[] getRow(int rowId) {
        return this.dictionary.getDictionaryValue(this.dimensionDataChunkStore.getSurrogate(rowId));
    }

    @Override
    public void fillRow(int rowId, CarbonColumnVector vector, int vectorRow) {
        int surrogate;
        if (!this.dictionary.isDictionaryUsed()) {
            vector.setDictionary(this.dictionary);
            this.dictionary.setDictionaryUsed();
        }
        if ((surrogate = this.dimensionDataChunkStore.getSurrogate(rowId)) == 1) {
            vector.putNull(vectorRow);
            vector.getDictionaryVector().putNull(vectorRow);
            return;
        }
        vector.putNotNull(vectorRow);
        vector.getDictionaryVector().putInt(vectorRow, this.dimensionDataChunkStore.getSurrogate(rowId));
    }

    @Override
    public void fillRow(int rowId, byte[] buffer, int offset) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public int getInvertedIndex(int rowId) {
        return this.dimensionDataChunkStore.getInvertedIndex(rowId);
    }

    @Override
    public int getInvertedReverseIndex(int rowId) {
        return this.dimensionDataChunkStore.getInvertedReverseIndex(rowId);
    }

    @Override
    public int getSurrogate(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public int getColumnValueSize() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public boolean isExplicitSorted() {
        return this.dimensionDataChunkStore.isExplicitSorted();
    }

    @Override
    public int compareTo(int rowId, byte[] compareValue) {
        return this.dimensionDataChunkStore.compareTo(rowId, compareValue);
    }

    @Override
    public void freeMemory() {
        if (null != this.dimensionDataChunkStore) {
            this.dimensionDataChunkStore.freeMemory();
            this.dictionary = null;
            this.dimensionDataChunkStore = null;
        }
    }
}

