/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store.impl.safe;

import org.apache.carbondata.core.datastore.chunk.store.impl.safe.AbstractNonDictionaryVectorFiller;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.util.DataTypeUtil;

class LongVectorFiller
extends AbstractNonDictionaryVectorFiller {
    public LongVectorFiller(int numberOfRows) {
        super(numberOfRows);
    }

    @Override
    public void fillVector(byte[] data, CarbonColumnVector vector) {
        int localOffset = 0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            int length = (data[localOffset] & 0xFF) << 8 | data[localOffset + 1] & 0xFF;
            localOffset += 2;
            if (length == 0) {
                vector.putNull(i);
            } else {
                vector.putLong(i, DataTypeUtil.getDataBasedOnRestructuredDataType(data, vector.getBlockDataType(), localOffset, length));
            }
            localOffset += length;
        }
    }
}

