/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store.impl.safe;

import org.apache.carbondata.core.datastore.chunk.store.impl.safe.AbstractNonDictionaryVectorFiller;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.BooleanVectorFiller;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.IntVectorFiller;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.LongStringVectorFiller;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.LongVectorFiller;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.ShortVectorFiller;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.StringVectorFiller;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.TimeStampVectorFiller;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;

class NonDictionaryVectorFillerFactory {
    NonDictionaryVectorFillerFactory() {
    }

    public static AbstractNonDictionaryVectorFiller getVectorFiller(int length, DataType type, int numberOfRows, int actualDataLength) {
        if (type == DataTypes.STRING) {
            if (length > DataTypes.SHORT.getSizeInBytes()) {
                return new LongStringVectorFiller(numberOfRows, actualDataLength);
            }
            return new StringVectorFiller(numberOfRows, actualDataLength);
        }
        if (type == DataTypes.VARCHAR || type == DataTypes.BINARY) {
            return new LongStringVectorFiller(numberOfRows, actualDataLength);
        }
        if (type == DataTypes.TIMESTAMP) {
            return new TimeStampVectorFiller(numberOfRows);
        }
        if (type == DataTypes.BOOLEAN) {
            return new BooleanVectorFiller(numberOfRows);
        }
        if (type == DataTypes.SHORT) {
            return new ShortVectorFiller(numberOfRows);
        }
        if (type == DataTypes.INT) {
            return new IntVectorFiller(numberOfRows);
        }
        if (type == DataTypes.LONG) {
            return new LongVectorFiller(numberOfRows);
        }
        throw new UnsupportedOperationException("Not supported datatype : " + type);
    }
}

