/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store.impl.safe;

import org.apache.carbondata.core.datastore.chunk.store.DimensionDataChunkStore;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;

public abstract class SafeAbsractDimensionDataChunkStore
implements DimensionDataChunkStore {
    protected byte[] data;
    protected int[] invertedIndex;
    protected int[] invertedIndexReverse;
    protected boolean isExplictSorted;

    public SafeAbsractDimensionDataChunkStore(boolean isInvertedIdex) {
        this.isExplictSorted = isInvertedIdex;
    }

    @Override
    public void putArray(int[] invertedIndex, int[] invertedIndexReverse, byte[] data) {
        this.data = data;
        this.invertedIndex = invertedIndex;
        this.invertedIndexReverse = invertedIndexReverse;
    }

    @Override
    public void freeMemory() {
        this.data = null;
        this.invertedIndex = null;
        this.invertedIndexReverse = null;
    }

    @Override
    public int getInvertedIndex(int rowId) {
        return this.invertedIndex[rowId];
    }

    @Override
    public int getInvertedReverseIndex(int rowId) {
        return this.invertedIndexReverse[rowId];
    }

    @Override
    public int getSurrogate(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public int getColumnValueSize() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public boolean isExplicitSorted() {
        return this.isExplictSorted;
    }

    @Override
    public void fillRow(int rowId, byte[] data, int offset) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void fillRow(int rowId, CarbonColumnVector vector, int vectorRow) {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

