/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store.impl.safe;

import java.util.BitSet;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.SafeAbsractDimensionDataChunkStore;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ColumnarVectorWrapperDirectFactory;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ConvertableVector;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;

public class SafeFixedLengthDimensionDataChunkStore
extends SafeAbsractDimensionDataChunkStore {
    private int columnValueSize;
    private int numOfRows;

    public SafeFixedLengthDimensionDataChunkStore(boolean isInvertedIndex, int columnValueSize, int numOfRows) {
        super(isInvertedIndex);
        this.columnValueSize = columnValueSize;
        this.numOfRows = numOfRows;
    }

    @Override
    public void fillVector(int[] invertedIndex, int[] invertedIndexReverse, byte[] data, ColumnVectorInfo vectorInfo) {
        CarbonColumnVector vector = vectorInfo.vector;
        BitSet deletedRows = vectorInfo.deletedRows;
        BitSet nullBits = new BitSet(this.numOfRows);
        vector = ColumnarVectorWrapperDirectFactory.getDirectVectorWrapperFactory(vector, invertedIndex, nullBits, deletedRows, false, false);
        this.fillVector(data, vectorInfo, vector);
        if (vector instanceof ConvertableVector) {
            ((ConvertableVector)((Object)vector)).convert();
        }
    }

    private void fillVector(byte[] data, ColumnVectorInfo vectorInfo, CarbonColumnVector vector) {
        DataType dataType = vectorInfo.vector.getBlockDataType();
        if (dataType == DataTypes.DATE) {
            for (int i = 0; i < this.numOfRows; ++i) {
                int surrogateInternal = CarbonUtil.getSurrogateInternal(data, i * this.columnValueSize, this.columnValueSize);
                if (surrogateInternal == 1) {
                    vector.putNull(i);
                    continue;
                }
                vector.putInt(i, surrogateInternal - 0x3FFFFFFF);
            }
        } else if (dataType == DataTypes.TIMESTAMP) {
            for (int i = 0; i < this.numOfRows; ++i) {
                int surrogateInternal = CarbonUtil.getSurrogateInternal(data, i * this.columnValueSize, this.columnValueSize);
                if (surrogateInternal == 1) {
                    vector.putNull(i);
                    continue;
                }
                Object valueFromSurrogate = vectorInfo.directDictionaryGenerator.getValueFromSurrogate(surrogateInternal);
                vector.putLong(i, (Long)valueFromSurrogate);
            }
        } else {
            for (int i = 0; i < this.numOfRows; ++i) {
                vector.putInt(i, CarbonUtil.getSurrogateInternal(data, i * this.columnValueSize, this.columnValueSize));
            }
        }
    }

    @Override
    public byte[] getRow(int rowId) {
        if (this.isExplictSorted) {
            rowId = this.invertedIndexReverse[rowId];
        }
        byte[] row = new byte[this.columnValueSize];
        System.arraycopy(this.data, rowId * this.columnValueSize, row, 0, this.columnValueSize);
        return row;
    }

    @Override
    public int getSurrogate(int index) {
        if (this.isExplictSorted) {
            index = this.invertedIndexReverse[index];
        }
        int startOffsetOfData = index * this.columnValueSize;
        return CarbonUtil.getSurrogateInternal(this.data, startOffsetOfData, this.columnValueSize);
    }

    @Override
    public void fillRow(int rowId, byte[] buffer, int offset) {
        if (this.isExplictSorted) {
            rowId = this.invertedIndexReverse[rowId];
        }
        System.arraycopy(this.data, rowId * this.columnValueSize, buffer, offset, this.columnValueSize);
    }

    @Override
    public int getColumnValueSize() {
        return this.columnValueSize;
    }

    @Override
    public int compareTo(int rowId, byte[] compareValue) {
        return ByteUtil.UnsafeComparer.INSTANCE.compareTo(this.data, rowId * this.columnValueSize, this.columnValueSize, compareValue, 0, this.columnValueSize);
    }
}

