/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store.impl.safe;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.AbstractNonDictionaryVectorFiller;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.NonDictionaryVectorFillerFactory;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.SafeAbsractDimensionDataChunkStore;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ColumnarVectorWrapperDirectFactory;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ConvertableVector;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;

public abstract class SafeVariableLengthDimensionDataChunkStore
extends SafeAbsractDimensionDataChunkStore {
    private int numberOfRows;
    private int[] dataOffsets;
    private int dataLength;

    public SafeVariableLengthDimensionDataChunkStore(boolean isInvertedIndex, int numberOfRows, int dataLength) {
        super(isInvertedIndex);
        this.numberOfRows = numberOfRows;
        this.dataOffsets = new int[numberOfRows];
        this.dataLength = dataLength;
    }

    @Override
    public void putArray(int[] invertedIndex, int[] invertedIndexReverse, byte[] data) {
        super.putArray(invertedIndex, invertedIndexReverse, data);
        this.dataOffsets = new int[this.numberOfRows];
        int startOffset = 0;
        this.dataOffsets[0] = this.getLengthSize();
        ByteBuffer buffer = ByteBuffer.wrap(data);
        for (int i = 1; i < this.numberOfRows; ++i) {
            buffer.position(startOffset);
            this.dataOffsets[i] = (startOffset += this.getLengthFromBuffer(buffer) + this.getLengthSize()) + this.getLengthSize();
        }
    }

    @Override
    public void fillVector(int[] invertedIndex, int[] invertedIndexReverse, byte[] data, ColumnVectorInfo vectorInfo) {
        CarbonColumnVector vector = vectorInfo.vector;
        vector.setDictionary(null);
        DataType dt = vector.getType();
        AbstractNonDictionaryVectorFiller vectorFiller = NonDictionaryVectorFillerFactory.getVectorFiller(this.getLengthSize(), dt, this.numberOfRows, this.dataLength);
        vector = ColumnarVectorWrapperDirectFactory.getDirectVectorWrapperFactory(vector, invertedIndex, new BitSet(), vectorInfo.deletedRows, false, false);
        vectorFiller.fillVector(data, vector);
        if (vector instanceof ConvertableVector) {
            ((ConvertableVector)((Object)vector)).convert();
        }
    }

    protected abstract int getLengthSize();

    protected abstract int getLengthFromBuffer(ByteBuffer var1);

    @Override
    public byte[] getRow(int rowId) {
        if (this.isExplictSorted) {
            rowId = this.invertedIndexReverse[rowId];
        }
        int currentDataOffset = this.dataOffsets[rowId];
        int length = 0;
        length = rowId < this.numberOfRows - 1 ? this.dataOffsets[rowId + 1] - (currentDataOffset + this.getLengthSize()) : this.dataLength - currentDataOffset;
        byte[] currentRowData = new byte[length];
        System.arraycopy(this.data, currentDataOffset, currentRowData, 0, length);
        return currentRowData;
    }

    @Override
    public void fillRow(int rowId, CarbonColumnVector vector, int vectorRow) {
        vector.setDictionary(null);
        if (this.isExplictSorted) {
            rowId = this.invertedIndexReverse[rowId];
        }
        int currentDataOffset = this.dataOffsets[rowId];
        int length = 0;
        length = rowId < this.numberOfRows - 1 ? this.dataOffsets[rowId + 1] - (currentDataOffset + this.getLengthSize()) : this.dataLength - currentDataOffset;
        DataType dt = vector.getType();
        if (dt != DataTypes.STRING && dt != DataTypes.VARCHAR && length == 0 || ByteUtil.UnsafeComparer.INSTANCE.equals(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY, 0, CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY.length, this.data, currentDataOffset, length)) {
            vector.putNull(vectorRow);
        } else if (dt == DataTypes.STRING || dt == DataTypes.VARCHAR || dt == DataTypes.BINARY) {
            vector.putByteArray(vectorRow, currentDataOffset, length, this.data);
        } else if (dt == DataTypes.BOOLEAN) {
            vector.putBoolean(vectorRow, ByteUtil.toBoolean(this.data[currentDataOffset]));
        } else if (dt == DataTypes.SHORT) {
            vector.putShort(vectorRow, ByteUtil.toXorShort(this.data, currentDataOffset, length));
        } else if (dt == DataTypes.INT) {
            vector.putInt(vectorRow, ByteUtil.toXorInt(this.data, currentDataOffset, length));
        } else if (dt == DataTypes.LONG) {
            vector.putLong(vectorRow, DataTypeUtil.getDataBasedOnRestructuredDataType(this.data, vector.getBlockDataType(), currentDataOffset, length));
        } else if (dt == DataTypes.TIMESTAMP) {
            vector.putLong(vectorRow, ByteUtil.toXorLong(this.data, currentDataOffset, length) * 1000L);
        }
    }

    @Override
    public int compareTo(int rowId, byte[] compareValue) {
        int currentDataOffset = this.dataOffsets[rowId];
        int length = 0;
        length = rowId < this.numberOfRows - 1 ? this.dataOffsets[rowId + 1] - (currentDataOffset + this.getLengthSize()) : this.dataLength - currentDataOffset;
        return ByteUtil.UnsafeComparer.INSTANCE.compareTo(this.data, currentDataOffset, length, compareValue, 0, compareValue.length);
    }

    @Override
    public void freeMemory() {
        super.freeMemory();
        this.dataOffsets = null;
    }
}

