/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store.impl.safe;

import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.chunk.store.impl.safe.AbstractNonDictionaryVectorFiller;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ColumnarVectorWrapperDirectWithInvertedIndex;
import org.apache.carbondata.core.scan.result.vector.impl.directread.SequentialFill;
import org.apache.carbondata.core.util.ByteUtil;

class StringVectorFiller
extends AbstractNonDictionaryVectorFiller {
    private int actualDataLength;

    public StringVectorFiller(int numberOfRows, int actualDataLength) {
        super(numberOfRows);
        this.actualDataLength = actualDataLength;
    }

    @Override
    public void fillVector(byte[] data, CarbonColumnVector vector) {
        boolean addSequential = vector instanceof ColumnarVectorWrapperDirectWithInvertedIndex || vector instanceof SequentialFill;
        int localOffset = 0;
        ByteUtil.UnsafeComparer comparator = ByteUtil.UnsafeComparer.INSTANCE;
        if (addSequential) {
            for (int i = 0; i < this.numberOfRows; ++i) {
                int length;
                if (comparator.equals(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY, 0, CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY.length, data, localOffset += 2, length = (data[localOffset] & 0xFF) << 8 | data[localOffset + 1] & 0xFF)) {
                    vector.putNull(i);
                } else {
                    vector.putByteArray(i, localOffset, length, data);
                }
                localOffset += length;
            }
        } else {
            for (int i = 0; i < this.numberOfRows; ++i) {
                int length;
                if (comparator.equals(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY, 0, CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY.length, data, localOffset += 2, length = (data[localOffset] & 0xFF) << 8 | data[localOffset + 1] & 0xFF)) {
                    vector.putNull(i);
                } else {
                    vector.putArray(i, localOffset, length);
                }
                localOffset += length;
            }
            vector.putAllByteArray(data, 0, this.actualDataLength);
        }
    }
}

