/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store.impl.unsafe;

import org.apache.carbondata.core.datastore.chunk.store.DimensionDataChunkStore;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.util.ThreadLocalTaskInfo;

public abstract class UnsafeAbstractDimensionDataChunkStore
implements DimensionDataChunkStore {
    protected MemoryBlock dataPageMemoryBlock;
    protected boolean isExplicitSorted;
    protected boolean isMemoryReleased;
    protected int dataLength;
    protected long invertedIndexReverseOffset;
    protected boolean isMemoryOccupied;
    private final String taskId = ThreadLocalTaskInfo.getCarbonTaskInfo().getTaskId();

    public UnsafeAbstractDimensionDataChunkStore(long totalSize, boolean isInvertedIdex, int numberOfRows, int dataLength) {
        this.dataPageMemoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(this.taskId, totalSize);
        this.dataLength = dataLength;
        this.isExplicitSorted = isInvertedIdex;
    }

    @Override
    public void putArray(int[] invertedIndex, int[] invertedIndexReverse, byte[] data) {
        assert (!this.isMemoryOccupied);
        this.invertedIndexReverseOffset = this.dataLength;
        if (this.isExplicitSorted) {
            this.invertedIndexReverseOffset += (long)(invertedIndex.length * 4);
        }
        CarbonUnsafe.getUnsafe().copyMemory(data, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset(), this.dataLength);
        if (this.isExplicitSorted) {
            CarbonUnsafe.getUnsafe().copyMemory(invertedIndex, CarbonUnsafe.INT_ARRAY_OFFSET, this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + (long)this.dataLength, invertedIndex.length * 4);
            CarbonUnsafe.getUnsafe().copyMemory(invertedIndexReverse, CarbonUnsafe.INT_ARRAY_OFFSET, this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + this.invertedIndexReverseOffset, invertedIndexReverse.length * 4);
        }
    }

    @Override
    public void fillVector(int[] invertedIndex, int[] invertedIndexReverse, byte[] data, ColumnVectorInfo vectorInfo) {
        throw new UnsupportedOperationException("This method not supposed to be called here");
    }

    @Override
    public void freeMemory() {
        if (this.isMemoryReleased) {
            return;
        }
        UnsafeMemoryManager.INSTANCE.freeMemory(this.taskId, this.dataPageMemoryBlock);
        this.isMemoryReleased = true;
        this.dataPageMemoryBlock = null;
        this.isMemoryOccupied = false;
    }

    @Override
    public int getInvertedIndex(int rowId) {
        return CarbonUnsafe.getUnsafe().getInt(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + (long)this.dataLength + (long)rowId * 4L);
    }

    @Override
    public int getInvertedReverseIndex(int rowId) {
        return CarbonUnsafe.getUnsafe().getInt(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + this.invertedIndexReverseOffset + (long)rowId * 4L);
    }

    @Override
    public int getSurrogate(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public int getColumnValueSize() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public boolean isExplicitSorted() {
        return this.isExplicitSorted;
    }

    @Override
    public void fillRow(int rowId, byte[] data, int offset) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void fillRow(int rowId, CarbonColumnVector vector, int vectorRow) {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

