/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store.impl.unsafe;

import org.apache.carbondata.core.datastore.chunk.store.impl.unsafe.UnsafeAbstractDimensionDataChunkStore;
import org.apache.carbondata.core.memory.CarbonUnsafe;

public class UnsafeFixedLengthDimensionDataChunkStore
extends UnsafeAbstractDimensionDataChunkStore {
    private int columnValueSize;

    public UnsafeFixedLengthDimensionDataChunkStore(long totalDataSize, int columnValueSize, boolean isInvertedIdex, int numberOfRows, int dataLength) {
        super(totalDataSize, isInvertedIdex, numberOfRows, dataLength);
        this.columnValueSize = columnValueSize;
    }

    @Override
    public byte[] getRow(int rowId) {
        if (this.isExplicitSorted) {
            rowId = CarbonUnsafe.getUnsafe().getInt(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + this.invertedIndexReverseOffset + (long)rowId * 4L);
        }
        byte[] data = new byte[this.columnValueSize];
        CarbonUnsafe.getUnsafe().copyMemory(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + (long)rowId * (long)this.columnValueSize, data, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.columnValueSize);
        return data;
    }

    @Override
    public int getSurrogate(int index) {
        if (this.isExplicitSorted) {
            index = CarbonUnsafe.getUnsafe().getInt(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + this.invertedIndexReverseOffset + (long)index * 4L);
        }
        int startOffsetOfData = index * this.columnValueSize;
        int surrogate = 0;
        for (int i = 0; i < this.columnValueSize; ++i) {
            surrogate <<= 8;
            surrogate ^= CarbonUnsafe.getUnsafe().getByte(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + (long)startOffsetOfData) & 0xFF;
            ++startOffsetOfData;
        }
        return surrogate;
    }

    @Override
    public void fillRow(int rowId, byte[] buffer, int offset) {
        if (this.isExplicitSorted) {
            rowId = CarbonUnsafe.getUnsafe().getInt(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + this.invertedIndexReverseOffset + (long)rowId * 4L);
        }
        CarbonUnsafe.getUnsafe().copyMemory(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + (long)rowId * (long)this.columnValueSize, buffer, CarbonUnsafe.BYTE_ARRAY_OFFSET + offset, this.columnValueSize);
    }

    @Override
    public int getColumnValueSize() {
        return this.columnValueSize;
    }

    @Override
    public int compareTo(int rowId, byte[] compareValue) {
        rowId *= this.columnValueSize;
        int compareResult = 0;
        for (int i = 0; i < compareValue.length && (compareResult = (CarbonUnsafe.getUnsafe().getByte(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + (long)rowId) & 0xFF) - (compareValue[i] & 0xFF)) == 0; ++i) {
            ++rowId;
        }
        return compareResult;
    }
}

