/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.chunk.store.impl.unsafe;

import java.nio.ByteBuffer;
import org.apache.carbondata.core.datastore.chunk.store.impl.unsafe.UnsafeAbstractDimensionDataChunkStore;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.scan.executor.util.QueryUtil;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;

public abstract class UnsafeVariableLengthDimensionDataChunkStore
extends UnsafeAbstractDimensionDataChunkStore {
    private int numberOfRows;
    private long dataPointersOffsets;
    private byte[] value;

    public UnsafeVariableLengthDimensionDataChunkStore(long totalSize, boolean isInvertedIdex, int numberOfRows, int dataLength) {
        super(totalSize, isInvertedIdex, numberOfRows, dataLength);
        this.numberOfRows = numberOfRows;
        this.value = new byte[20];
    }

    @Override
    public void putArray(int[] invertedIndex, int[] invertedIndexReverse, byte[] data) {
        super.putArray(invertedIndex, invertedIndexReverse, data);
        this.dataPointersOffsets = this.invertedIndexReverseOffset;
        if (this.isExplicitSorted) {
            this.dataPointersOffsets += (long)this.numberOfRows * 4L;
        }
        int startOffset = 0;
        int[] dataOffsets = new int[this.numberOfRows];
        dataOffsets[0] = this.getLengthSize();
        ByteBuffer buffer = ByteBuffer.wrap(data);
        for (int i = 1; i < this.numberOfRows; ++i) {
            buffer.position(startOffset);
            dataOffsets[i] = (startOffset += this.getLengthFromBuffer(buffer) + this.getLengthSize()) + this.getLengthSize();
        }
        CarbonUnsafe.getUnsafe().copyMemory(dataOffsets, CarbonUnsafe.INT_ARRAY_OFFSET, this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + this.dataPointersOffsets, dataOffsets.length * 4);
    }

    protected abstract int getLengthSize();

    protected abstract int getLengthFromBuffer(ByteBuffer var1);

    @Override
    public byte[] getRow(int rowId) {
        rowId = this.getRowId(rowId);
        int currentDataOffset = this.getOffSet(rowId);
        int length = this.getLength(rowId, currentDataOffset);
        byte[] data = new byte[length];
        this.fillRowInternal(length, data, currentDataOffset);
        return data;
    }

    private int getRowId(int rowId) {
        if (this.isExplicitSorted) {
            rowId = CarbonUnsafe.getUnsafe().getInt(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + this.invertedIndexReverseOffset + (long)rowId * 4L);
        }
        return rowId;
    }

    private int getOffSet(int rowId) {
        return CarbonUnsafe.getUnsafe().getInt(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + this.dataPointersOffsets + (long)rowId * 4L);
    }

    private int getLength(int rowId, int currentDataOffset) {
        int length = 0;
        if (rowId < this.numberOfRows - 1) {
            int OffsetOfNextdata = CarbonUnsafe.getUnsafe().getInt(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + this.dataPointersOffsets + (long)((rowId + 1) * 4));
            length = OffsetOfNextdata - (currentDataOffset + this.getLengthSize());
        } else {
            length = this.dataLength - currentDataOffset;
        }
        return length;
    }

    private void fillRowInternal(int length, byte[] data, int currentDataOffset) {
        CarbonUnsafe.getUnsafe().copyMemory(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + (long)currentDataOffset, data, CarbonUnsafe.BYTE_ARRAY_OFFSET, length);
    }

    @Override
    public void fillRow(int rowId, CarbonColumnVector vector, int vectorRow) {
        vector.setDictionary(null);
        rowId = this.getRowId(rowId);
        int currentDataOffset = this.getOffSet(rowId);
        int length = this.getLength(rowId, currentDataOffset);
        if (length > this.value.length) {
            this.value = new byte[length];
        }
        this.fillRowInternal(length, this.value, currentDataOffset);
        QueryUtil.putDataToVector(vector, this.value, vectorRow, length);
    }

    @Override
    public int compareTo(int rowId, byte[] compareValue) {
        int currentDataOffset = this.getOffSet(rowId);
        int length = this.getLength(rowId, currentDataOffset);
        int compareLength = Math.min(length, compareValue.length);
        for (int i = 0; i < compareLength; ++i) {
            int compareResult = (CarbonUnsafe.getUnsafe().getByte(this.dataPageMemoryBlock.getBaseObject(), this.dataPageMemoryBlock.getBaseOffset() + (long)currentDataOffset) & 0xFF) - (compareValue[i] & 0xFF);
            if (compareResult != 0) {
                return compareResult;
            }
            ++currentDataOffset;
        }
        return length - compareValue.length;
    }
}

