/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.columnar;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.util.ByteUtil;

public abstract class BlockIndexerStorage<T> {
    protected short[] rowIdPage;
    protected short[] rowIdRlePage;
    protected T dataPage;
    protected short[] dataRlePage;

    public short[] getRowIdPage() {
        return this.rowIdPage;
    }

    public int getRowIdPageLengthInBytes() {
        if (this.rowIdPage != null) {
            return this.rowIdPage.length * 2;
        }
        return 0;
    }

    public short[] getRowIdRlePage() {
        return this.rowIdRlePage;
    }

    public int getRowIdRlePageLengthInBytes() {
        if (this.rowIdRlePage != null) {
            return this.rowIdRlePage.length * 2;
        }
        return 0;
    }

    public T getDataPage() {
        return this.dataPage;
    }

    public short[] getDataRlePage() {
        return this.dataRlePage;
    }

    public int getDataRlePageLengthInBytes() {
        if (this.dataRlePage != null) {
            return this.dataRlePage.length * 2;
        }
        return 0;
    }

    protected void encodeAndSetRowId(short[] rowIds) {
        int i;
        ArrayList<Short> list = new ArrayList<Short>(10);
        ArrayList<Short> map = new ArrayList<Short>(10);
        int k = 0;
        for (i = 1; i < rowIds.length; ++i) {
            if (rowIds[i] - rowIds[i - 1] == 1) {
                ++k;
                continue;
            }
            if (k > 0) {
                map.add((short)list.size());
                list.add(rowIds[i - k - 1]);
                list.add(rowIds[i - 1]);
            } else {
                list.add(rowIds[i - 1]);
            }
            k = 0;
        }
        if (k > 0) {
            map.add((short)list.size());
            list.add(rowIds[i - k - 1]);
            list.add(rowIds[i - 1]);
        } else {
            list.add(rowIds[i - 1]);
        }
        if ((list.size() + map.size()) * 100 / rowIds.length > 70) {
            this.rowIdPage = rowIds;
            this.rowIdRlePage = new short[0];
        } else {
            this.rowIdPage = this.convertToArray(list);
            this.rowIdRlePage = this.convertToArray(map);
        }
    }

    protected byte[][] rleEncodeOnData(byte[][] dataPage) {
        ArrayList<Short> map = new ArrayList<Short>(10);
        ArrayList<byte[]> list = new ArrayList<byte[]>(dataPage.length / 2);
        list.add(dataPage[0]);
        short counter = 1;
        short startIdx = 0;
        for (int i = 1; i < dataPage.length; ++i) {
            if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(dataPage[i - 1], dataPage[i]) != 0) {
                list.add(dataPage[i]);
                map.add(startIdx);
                map.add(counter);
                startIdx = (short)(startIdx + counter);
                counter = 1;
                continue;
            }
            counter = (short)(counter + 1);
        }
        map.add(startIdx);
        map.add(counter);
        if ((list.size() + map.size()) * 100 / dataPage.length > 70) {
            this.dataRlePage = new short[0];
            return dataPage;
        }
        this.dataRlePage = this.convertToArray(map);
        return this.convertToDataPage(list);
    }

    private short[] convertToArray(List<Short> list) {
        short[] shortArray = new short[list.size()];
        for (int i = 0; i < shortArray.length; ++i) {
            shortArray[i] = list.get(i);
        }
        return shortArray;
    }

    private byte[][] convertToDataPage(List<byte[]> list) {
        byte[][] shortArray = new byte[list.size()][];
        for (int i = 0; i < shortArray.length; ++i) {
            shortArray[i] = list.get(i);
        }
        return shortArray;
    }
}

