/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.columnar;

import java.util.Arrays;
import org.apache.carbondata.core.datastore.columnar.BlockIndexerStorage;
import org.apache.carbondata.core.datastore.columnar.ByteArrayColumnWithRowId;

public class ByteArrayBlockIndexerStorage
extends BlockIndexerStorage<byte[][]> {
    public ByteArrayBlockIndexerStorage(byte[][] dataPage, boolean rleOnData, boolean isNoDictionary, boolean isSortRequired) {
        Object[] dataWithRowId = this.createColumnWithRowId(dataPage, isNoDictionary);
        if (isSortRequired) {
            Arrays.sort(dataWithRowId);
        }
        short[] rowIds = this.extractDataAndReturnRowId((ByteArrayColumnWithRowId[])dataWithRowId, dataPage);
        this.encodeAndSetRowId(rowIds);
        this.dataPage = rleOnData ? (Object)this.rleEncodeOnData(dataPage) : (Object)dataPage;
    }

    private ByteArrayColumnWithRowId[] createColumnWithRowId(byte[][] dataPage, boolean isNoDictionary) {
        ByteArrayColumnWithRowId[] columnWithIndexs = new ByteArrayColumnWithRowId[dataPage.length];
        if (isNoDictionary) {
            for (short i = 0; i < columnWithIndexs.length; i = (short)(i + 1)) {
                columnWithIndexs[i] = new ByteArrayColumnWithRowId(dataPage[i], i);
            }
        } else {
            for (short i = 0; i < columnWithIndexs.length; i = (short)(i + 1)) {
                columnWithIndexs[i] = new ByteArrayColumnWithRowId(dataPage[i], i);
            }
        }
        return columnWithIndexs;
    }

    private short[] extractDataAndReturnRowId(ByteArrayColumnWithRowId[] dataWithRowId, byte[][] dataPage) {
        short[] indexes = new short[dataWithRowId.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = dataWithRowId[i].getRowId();
            dataPage[i] = dataWithRowId[i].getColumn();
        }
        this.dataPage = dataPage;
        return indexes;
    }
}

