/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.columnar;

import java.util.Arrays;
import org.apache.carbondata.core.datastore.columnar.BlockIndexerStorage;
import org.apache.carbondata.core.datastore.columnar.ObjectColumnWithRowId;
import org.apache.carbondata.core.metadata.datatype.DataType;

public class ObjectArrayBlockIndexerStorage
extends BlockIndexerStorage<Object[]> {
    private DataType dataType;

    public ObjectArrayBlockIndexerStorage(Object[] dataPage, DataType dataType, boolean isSortRequired) {
        this.dataType = dataType;
        Object[] dataWithRowId = this.createColumnWithRowId(dataPage);
        if (isSortRequired) {
            Arrays.sort(dataWithRowId);
        }
        short[] rowIds = this.extractDataAndReturnRowId((ObjectColumnWithRowId[])dataWithRowId, dataPage);
        this.encodeAndSetRowId(rowIds);
    }

    private ObjectColumnWithRowId[] createColumnWithRowId(Object[] dataPage) {
        ObjectColumnWithRowId[] columnWithIndexs = new ObjectColumnWithRowId[dataPage.length];
        for (short i = 0; i < columnWithIndexs.length; i = (short)(i + 1)) {
            columnWithIndexs[i] = new ObjectColumnWithRowId(dataPage[i], i, this.dataType);
        }
        return columnWithIndexs;
    }

    private short[] extractDataAndReturnRowId(ObjectColumnWithRowId[] dataWithRowId, Object[] dataPage) {
        short[] indexes = new short[dataWithRowId.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = dataWithRowId[i].getRowId();
            dataPage[i] = dataWithRowId[i].getColumn();
        }
        this.dataPage = dataPage;
        return indexes;
    }

    @Override
    public short[] getDataRlePage() {
        return new short[0];
    }

    @Override
    public int getDataRlePageLengthInBytes() {
        return 0;
    }
}

