/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.columnar;

import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;

public class ObjectColumnWithRowId
implements Comparable<ObjectColumnWithRowId> {
    private Object column;
    private short rowId;
    private DataType dataType;

    ObjectColumnWithRowId(Object column, short rowId, DataType dataType) {
        this.column = column;
        this.rowId = rowId;
        this.dataType = dataType;
    }

    public Object getColumn() {
        return this.column;
    }

    public short getRowId() {
        return this.rowId;
    }

    @Override
    public int compareTo(ObjectColumnWithRowId o) {
        SerializableComparator comparator = Comparator.getComparator(this.dataType);
        return comparator.compare(this.column, o.column);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectColumnWithRowId o = (ObjectColumnWithRowId)obj;
        return this.column.equals(o.column) && this.rowId == o.rowId;
    }

    public int hashCode() {
        return this.column.hashCode() + Short.hashCode(this.rowId);
    }
}

