/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.columnar;

import java.util.Arrays;

public final class UnBlockIndexer {
    private UnBlockIndexer() {
    }

    public static int[] uncompressIndex(int[] indexData, int[] indexMap) {
        int actualSize = indexData.length;
        int mapLength = indexMap.length;
        if (indexMap.length == 0) {
            return indexData;
        }
        for (int i = 0; i < mapLength; ++i) {
            actualSize += indexData[indexMap[i] + 1] - indexData[indexMap[i]] - 1;
        }
        int[] indexes = new int[actualSize];
        int k = 0;
        int oldIndex = 0;
        for (int i = 0; i < indexData.length; ++i) {
            int index = Arrays.binarySearch(indexMap, oldIndex, mapLength, i);
            if (index > -1) {
                oldIndex = index;
                int j = indexData[indexMap[index]];
                while (j <= indexData[indexMap[index] + 1]) {
                    indexes[k] = j++;
                    ++k;
                }
                ++i;
                continue;
            }
            indexes[k] = indexData[i];
            ++k;
        }
        return indexes;
    }

    public static byte[] uncompressData(byte[] data, int[] index, int keyLen, int dataLength) {
        if (index.length < 1) {
            return data;
        }
        int numberOfCopy = 0;
        int actualSize = 0;
        int srcPos = 0;
        int destPos = 0;
        for (int i = 1; i < index.length; i += 2) {
            actualSize += index[i];
        }
        byte[] uncompressedData = new byte[actualSize * keyLen];
        int picIndex = 0;
        for (int i = 0; i < dataLength; i += keyLen) {
            numberOfCopy = index[picIndex * 2 + 1];
            ++picIndex;
            for (int j = 0; j < numberOfCopy; ++j) {
                System.arraycopy(data, srcPos, uncompressedData, destPos, keyLen);
                destPos += keyLen;
            }
            srcPos += keyLen;
        }
        return uncompressedData;
    }
}

