/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;

public abstract class AbstractCompressor
implements Compressor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer compressShort(short[] unCompInput) {
        ByteBuffer unCompBuffer = ByteBuffer.allocateDirect(unCompInput.length * 2);
        try {
            unCompBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().put(unCompInput);
            unCompBuffer.position(unCompBuffer.limit());
            ByteBuffer byteBuffer = this.compressByte(unCompBuffer);
            return byteBuffer;
        }
        finally {
            UnsafeMemoryManager.destroyDirectByteBuffer(unCompBuffer);
        }
    }

    @Override
    public short[] unCompressShort(byte[] compInput, int offset, int length) {
        byte[] unCompArray = this.unCompressByte(compInput, offset, length);
        ShortBuffer unCompBuffer = ByteBuffer.wrap(unCompArray).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] shorts = new short[unCompArray.length / 2];
        unCompBuffer.get(shorts);
        return shorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer compressInt(int[] unCompInput) {
        ByteBuffer unCompBuffer = ByteBuffer.allocateDirect(unCompInput.length * 4);
        try {
            unCompBuffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().put(unCompInput);
            unCompBuffer.position(unCompBuffer.limit());
            ByteBuffer byteBuffer = this.compressByte(unCompBuffer);
            return byteBuffer;
        }
        finally {
            UnsafeMemoryManager.destroyDirectByteBuffer(unCompBuffer);
        }
    }

    @Override
    public int[] unCompressInt(byte[] compInput, int offset, int length) {
        byte[] unCompArray = this.unCompressByte(compInput, offset, length);
        IntBuffer unCompBuffer = ByteBuffer.wrap(unCompArray).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] ints = new int[unCompArray.length / 4];
        unCompBuffer.get(ints);
        return ints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer compressLong(long[] unCompInput) {
        ByteBuffer unCompBuffer = ByteBuffer.allocateDirect(unCompInput.length * 8);
        try {
            unCompBuffer.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().put(unCompInput);
            unCompBuffer.position(unCompBuffer.limit());
            ByteBuffer byteBuffer = this.compressByte(unCompBuffer);
            return byteBuffer;
        }
        finally {
            UnsafeMemoryManager.destroyDirectByteBuffer(unCompBuffer);
        }
    }

    @Override
    public long[] unCompressLong(byte[] compInput, int offset, int length) {
        byte[] unCompArray = this.unCompressByte(compInput, offset, length);
        LongBuffer unCompBuffer = ByteBuffer.wrap(unCompArray).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        long[] longs = new long[unCompArray.length / 8];
        unCompBuffer.get(longs);
        return longs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer compressFloat(float[] unCompInput) {
        ByteBuffer unCompBuffer = ByteBuffer.allocateDirect(unCompInput.length * 4);
        try {
            unCompBuffer.order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().put(unCompInput);
            unCompBuffer.position(unCompBuffer.limit());
            ByteBuffer byteBuffer = this.compressByte(unCompBuffer);
            return byteBuffer;
        }
        finally {
            UnsafeMemoryManager.destroyDirectByteBuffer(unCompBuffer);
        }
    }

    @Override
    public float[] unCompressFloat(byte[] compInput, int offset, int length) {
        byte[] unCompArray = this.unCompressByte(compInput, offset, length);
        FloatBuffer unCompBuffer = ByteBuffer.wrap(unCompArray).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        float[] floats = new float[unCompArray.length / 4];
        unCompBuffer.get(floats);
        return floats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer compressDouble(double[] unCompInput) {
        ByteBuffer unCompBuffer = ByteBuffer.allocateDirect(unCompInput.length * 8);
        try {
            unCompBuffer.order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer().put(unCompInput);
            unCompBuffer.position(unCompBuffer.limit());
            ByteBuffer byteBuffer = this.compressByte(unCompBuffer);
            return byteBuffer;
        }
        finally {
            UnsafeMemoryManager.destroyDirectByteBuffer(unCompBuffer);
        }
    }

    @Override
    public double[] unCompressDouble(byte[] compInput, int offset, int length) {
        byte[] unCompArray = this.unCompressByte(compInput, offset, length);
        DoubleBuffer unCompBuffer = ByteBuffer.wrap(unCompArray).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        double[] doubles = new double[unCompArray.length / 8];
        unCompBuffer.get(doubles);
        return doubles;
    }

    @Override
    public long rawCompress(long inputAddress, int inputSize, long outputAddress) throws IOException {
        throw new RuntimeException("Not implemented rawCompress for " + this.getName());
    }

    @Override
    public boolean supportReusableBuffer() {
        return false;
    }

    @Override
    public boolean supportUnsafe() {
        return false;
    }
}

