/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.compression;

import java.util.HashMap;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.GzipCompressor;
import org.apache.carbondata.core.datastore.compression.SnappyCompressor;
import org.apache.carbondata.core.datastore.compression.ZstdCompressor;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CompressorFactory {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CompressorFactory.class.getName());
    private static final CompressorFactory COMPRESSOR_FACTORY = new CompressorFactory();
    private final Map<String, Compressor> allSupportedCompressors = new HashMap<String, Compressor>();

    private CompressorFactory() {
        for (NativeSupportedCompressor nativeSupportedCompressor : NativeSupportedCompressor.values()) {
            this.allSupportedCompressors.put(nativeSupportedCompressor.getName(), nativeSupportedCompressor.getCompressor());
        }
    }

    public static CompressorFactory getInstance() {
        return COMPRESSOR_FACTORY;
    }

    private Compressor registerColumnCompressor(String compressorClassName) {
        if (this.allSupportedCompressors.containsKey(compressorClassName)) {
            return this.allSupportedCompressors.get(compressorClassName);
        }
        try {
            Class<?> clazz = Class.forName(compressorClassName);
            Object instance = clazz.newInstance();
            if (instance instanceof Compressor) {
                if (!((Compressor)instance).getName().equals(compressorClassName)) {
                    throw new RuntimeException(String.format("For not carbondata native supported compressor, the result of method getName() should be the full class name. Expected '%s', found '%s'", compressorClassName, ((Compressor)instance).getName()));
                }
                this.allSupportedCompressors.put(compressorClassName, (Compressor)instance);
                LOGGER.info((Object)String.format("sucessfully register compressor %s to carbondata", compressorClassName));
                return (Compressor)instance;
            }
            throw new RuntimeException(String.format("Compressor '%s' should be a subclass of '%s'", compressorClassName, Compressor.class.getCanonicalName()));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.error((Object)String.format("Failed to register compressor '%s'", compressorClassName), (Throwable)e);
            throw new RuntimeException(String.format("Failed to load compressor '%s', currently carbondata supports %s", compressorClassName, StringUtils.join(this.allSupportedCompressors.keySet(), (String)", ")), e);
        }
    }

    public Compressor getCompressor() {
        String compressorType = CarbonProperties.getInstance().getProperty("carbon.column.compressor", "snappy");
        return this.getCompressor(compressorType);
    }

    public Compressor getCompressor(String name) {
        String internalCompressorName = this.getInternalCompressorName(name);
        if (null == internalCompressorName) {
            return this.registerColumnCompressor(name);
        }
        return this.allSupportedCompressors.get(internalCompressorName);
    }

    private String getInternalCompressorName(String name) {
        for (String key : this.allSupportedCompressors.keySet()) {
            if (!key.equalsIgnoreCase(name)) continue;
            return key;
        }
        return null;
    }

    public static enum NativeSupportedCompressor {
        SNAPPY("snappy", SnappyCompressor.class),
        ZSTD("zstd", ZstdCompressor.class),
        GZIP("gzip", GzipCompressor.class);

        private String name;
        private Class<Compressor> compressorClass;
        private transient Compressor compressor;

        private NativeSupportedCompressor(String name, Class compressorCls) {
            this.name = name;
            this.compressorClass = compressorCls;
        }

        public String getName() {
            return this.name;
        }

        public Compressor getCompressor() {
            if (this.compressor == null) {
                try {
                    this.compressor = this.compressorClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Exception occurs while getting compressor for " + this.name, e);
                }
            }
            return this.compressor;
        }
    }
}

