/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.compression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.carbondata.core.datastore.compression.AbstractCompressor;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class GzipCompressor
extends AbstractCompressor {
    @Override
    public String getName() {
        return "gzip";
    }

    private byte[] compressData(byte[] data) {
        return this.compressData(data, 0, data.length);
    }

    private byte[] compressData(byte[] data, int offset, int length) {
        int initialSize = length / 2 == 0 ? length : length / 2;
        ByteArrayOutputStream output = new ByteArrayOutputStream(initialSize);
        try (GzipCompressorOutputStream stream = new GzipCompressorOutputStream((OutputStream)output);){
            stream.write(data, offset, length);
        }
        catch (IOException e) {
            throw new RuntimeException("Error during Compression writing step ", e);
        }
        return output.toByteArray();
    }

    private byte[] compressData(ByteBuffer input) {
        input.flip();
        int initialSize = input.limit() / 2 == 0 ? input.limit() : input.limit() / 2;
        ByteArrayOutputStream output = new ByteArrayOutputStream(initialSize);
        try (GzipCompressorOutputStream stream = new GzipCompressorOutputStream((OutputStream)output);){
            for (int i = 0; i < input.limit(); ++i) {
                stream.write((int)input.get(i));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error during Compression writing step ", e);
        }
        return output.toByteArray();
    }

    private byte[] decompressData(byte[] data, int offset, int length) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data, offset, length);
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try {
            int len;
            GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream((InputStream)byteArrayInputStream);
            int initialSize = data.length * 2 < Integer.MAX_VALUE ? data.length * 2 : data.length;
            byte[] buffer = new byte[initialSize];
            while ((len = gzipCompressorInputStream.read(buffer)) != -1) {
                byteOutputStream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error during Decompression step ", e);
        }
        return byteOutputStream.toByteArray();
    }

    @Override
    public ByteBuffer compressByte(ByteBuffer compInput) {
        if (compInput.isDirect()) {
            return ByteBuffer.wrap(this.compressData(compInput));
        }
        byte[] output = this.compressData(compInput.array(), 0, compInput.position());
        return ByteBuffer.wrap(output);
    }

    @Override
    public ByteBuffer compressByte(byte[] unCompInput) {
        return ByteBuffer.wrap(this.compressData(unCompInput));
    }

    @Override
    public byte[] compressByte(byte[] unCompInput, int byteSize) {
        return this.compressData(unCompInput);
    }

    @Override
    public byte[] unCompressByte(byte[] compInput) {
        return this.decompressData(compInput, 0, compInput.length);
    }

    @Override
    public byte[] unCompressByte(byte[] compInput, int offset, int length) {
        return this.decompressData(compInput, offset, length);
    }

    @Override
    public long rawUncompress(byte[] input, byte[] output) {
        throw new RuntimeException("Not implemented rawUcompress for gzip yet");
    }

    @Override
    public long maxCompressedLength(long inputSize) {
        if (inputSize < Integer.MAX_VALUE) {
            return inputSize;
        }
        throw new RuntimeException("compress input oversize for gzip");
    }

    @Override
    public int unCompressedLength(byte[] data, int offset, int length) {
        throw new RuntimeException("Unsupported operation Exception");
    }

    @Override
    public int rawUncompress(byte[] data, int offset, int length, byte[] output) {
        throw new RuntimeException("Not implemented rawUcompress for gzip yet");
    }
}

