/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.compression;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.compression.AbstractCompressor;
import org.apache.log4j.Logger;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyNative;

public class SnappyCompressor
extends AbstractCompressor {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)SnappyCompressor.class.getName());
    public static final int MAX_BYTE_TO_COMPRESS = 1840700241;
    private final transient SnappyNative snappyNative;

    public SnappyCompressor() {
        Snappy snappy = new Snappy();
        Field privateField = null;
        try {
            privateField = snappy.getClass().getDeclaredField("impl");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
        privateField.setAccessible(true);
        try {
            this.snappyNative = (SnappyNative)privateField.get(snappy);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return "snappy";
    }

    @Override
    public ByteBuffer compressByte(ByteBuffer compInput) {
        int outputSize;
        int inputLength = compInput.position();
        ByteBuffer output = ByteBuffer.allocateDirect(Snappy.maxCompressedLength((int)inputLength));
        compInput.flip();
        try {
            outputSize = Snappy.compress((ByteBuffer)compInput, (ByteBuffer)output);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        output.limit(outputSize);
        return output;
    }

    @Override
    public ByteBuffer compressByte(byte[] unCompInput) {
        try {
            return ByteBuffer.wrap(Snappy.rawCompress((Object)unCompInput, (int)unCompInput.length));
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] compressByte(byte[] unCompInput, int byteSize) {
        try {
            return Snappy.rawCompress((Object)unCompInput, (int)byteSize);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] unCompressByte(byte[] compInput) {
        try {
            return Snappy.uncompress((byte[])compInput);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] unCompressByte(byte[] compInput, int offset, int length) {
        byte[] data;
        int uncompressedLength = 0;
        try {
            uncompressedLength = Snappy.uncompressedLength((byte[])compInput, (int)offset, (int)length);
            data = new byte[uncompressedLength];
            this.snappyNative.rawUncompress((Object)compInput, offset, length, (Object)data, 0);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return data;
    }

    @Override
    public short[] unCompressShort(byte[] compInput, int offset, int length) {
        try {
            return Snappy.uncompressShortArray((byte[])compInput, (int)offset, (int)length);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public int[] unCompressInt(byte[] compInput, int offset, int length) {
        try {
            return Snappy.uncompressIntArray((byte[])compInput, (int)offset, (int)length);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public long[] unCompressLong(byte[] compInput, int offset, int length) {
        try {
            return Snappy.uncompressLongArray((byte[])compInput, (int)offset, (int)length);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public float[] unCompressFloat(byte[] compInput, int offset, int length) {
        try {
            return Snappy.uncompressFloatArray((byte[])compInput, (int)offset, (int)length);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public double[] unCompressDouble(byte[] compInput, int offset, int length) {
        try {
            int uncompressedLength = Snappy.uncompressedLength((byte[])compInput, (int)offset, (int)length);
            double[] result = new double[uncompressedLength / 8];
            this.snappyNative.rawUncompress((Object)compInput, offset, length, (Object)result, 0);
            return result;
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public long rawCompress(long inputAddress, int inputSize, long outputAddress) throws IOException {
        return this.snappyNative.rawCompress(inputAddress, (long)inputSize, outputAddress);
    }

    @Override
    public long rawUncompress(byte[] input, byte[] output) throws IOException {
        return this.snappyNative.rawUncompress((Object)input, 0, input.length, (Object)output, 0);
    }

    @Override
    public long maxCompressedLength(long inputSize) {
        return this.snappyNative.maxCompressedLength((int)inputSize);
    }

    @Override
    public boolean supportUnsafe() {
        return true;
    }

    @Override
    public int unCompressedLength(byte[] data, int offset, int length) {
        try {
            return Snappy.uncompressedLength((byte[])data, (int)offset, (int)length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int rawUncompress(byte[] data, int offset, int length, byte[] output) {
        try {
            return Snappy.rawUncompress((byte[])data, (int)offset, (int)length, (Object)output, (int)0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean supportReusableBuffer() {
        return true;
    }
}

