/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.compression;

import com.github.luben.zstd.Zstd;
import java.nio.ByteBuffer;
import org.apache.carbondata.core.datastore.compression.AbstractCompressor;

public class ZstdCompressor
extends AbstractCompressor {
    private static final int COMPRESS_LEVEL = 3;

    @Override
    public String getName() {
        return "zstd";
    }

    @Override
    public ByteBuffer compressByte(ByteBuffer compInput) {
        compInput.flip();
        if (compInput.isDirect()) {
            return Zstd.compress((ByteBuffer)compInput, (int)3);
        }
        return ByteBuffer.wrap(Zstd.compress((byte[])compInput.array(), (int)3));
    }

    @Override
    public ByteBuffer compressByte(byte[] unCompInput) {
        return ByteBuffer.wrap(Zstd.compress((byte[])unCompInput, (int)3));
    }

    @Override
    public byte[] compressByte(byte[] unCompInput, int byteSize) {
        return Zstd.compress((byte[])unCompInput, (int)3);
    }

    @Override
    public byte[] unCompressByte(byte[] compInput) {
        long decompressedSize = Zstd.decompressedSize((byte[])compInput);
        return Zstd.decompress((byte[])compInput, (int)((int)decompressedSize));
    }

    @Override
    public byte[] unCompressByte(byte[] compInput, int offset, int length) {
        byte[] dstBytes = new byte[length];
        System.arraycopy(compInput, offset, dstBytes, 0, length);
        return this.unCompressByte(dstBytes);
    }

    @Override
    public long rawUncompress(byte[] input, byte[] output) {
        return Zstd.decompress((byte[])output, (byte[])input);
    }

    @Override
    public long maxCompressedLength(long inputSize) {
        return Zstd.compressBound((long)inputSize);
    }

    @Override
    public int unCompressedLength(byte[] data, int offset, int length) {
        throw new RuntimeException("Unsupported operation Exception");
    }

    @Override
    public int rawUncompress(byte[] data, int offset, int length, byte[] output) {
        throw new RuntimeException("Unsupported operation Exception");
    }
}

