/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.filesystem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.exception.CarbonFileException;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.Lz4Codec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.log4j.Logger;

public abstract class AbstractDFSCarbonFile
implements CarbonFile {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)AbstractDFSCarbonFile.class.getName());
    protected FileSystem fileSystem;
    protected Configuration hadoopConf;
    protected Path path;

    AbstractDFSCarbonFile(String filePath) {
        this(filePath, FileFactory.getConfiguration());
    }

    AbstractDFSCarbonFile(String filePath, Configuration hadoopConf) {
        this(new Path(filePath), hadoopConf);
    }

    AbstractDFSCarbonFile(Path path) {
        this(path, FileFactory.getConfiguration());
    }

    AbstractDFSCarbonFile(Path path, Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
        try {
            Path newPath = new Path(path.toString().replace("\\", "/"));
            this.fileSystem = newPath.getFileSystem(this.hadoopConf);
            this.path = newPath;
        }
        catch (IOException e) {
            throw new CarbonFileException("Error while getting File System: ", e);
        }
    }

    AbstractDFSCarbonFile(FileStatus fileStatus) {
        this(fileStatus.getPath());
    }

    @Override
    public boolean createNewFile() {
        try {
            return this.fileSystem.createNewFile(this.path);
        }
        catch (IOException e) {
            throw new CarbonFileException("Unable to create file: " + this.path.toString(), e);
        }
    }

    @Override
    public String getAbsolutePath() {
        try {
            return this.fileSystem.getFileStatus(this.path).getPath().toString();
        }
        catch (IOException e) {
            throw new CarbonFileException("Unable to get file status: ", e);
        }
    }

    @Override
    public String getName() {
        return this.path.getName();
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.fileSystem.getFileStatus(this.path).isDirectory();
        }
        catch (IOException e) {
            throw new CarbonFileException("Unable to get file status: ", e);
        }
    }

    @Override
    public CarbonFile getParentFile() {
        Path parentPath = this.path.getParent();
        return parentPath == null ? null : FileFactory.getCarbonFile(parentPath.toString());
    }

    @Override
    public boolean exists() {
        try {
            return this.fileSystem.exists(this.path);
        }
        catch (IOException e) {
            throw new CarbonFileException(e);
        }
    }

    @Override
    public String getCanonicalPath() {
        return this.getAbsolutePath();
    }

    @Override
    public String getPath() {
        return this.getAbsolutePath();
    }

    @Override
    public long getSize() {
        try {
            return this.fileSystem.getFileStatus(this.path).getLen();
        }
        catch (IOException e) {
            throw new CarbonFileException("Unable to get file status for " + this.path.toString(), e);
        }
    }

    @Override
    public boolean renameTo(String changetoName) {
        try {
            return this.fileSystem.rename(this.path, new Path(changetoName));
        }
        catch (IOException e) {
            throw new CarbonFileException("Failed to rename file: ", e);
        }
    }

    @Override
    public boolean delete() {
        try {
            return this.fileSystem.delete(this.path, true);
        }
        catch (IOException e) {
            throw new CarbonFileException("Failed to delete file:", e);
        }
    }

    @Override
    public long getLastModifiedTime() {
        try {
            return this.fileSystem.getFileStatus(this.path).getModificationTime();
        }
        catch (IOException e) {
            throw new CarbonFileException("Unable to get file status: ", e);
        }
    }

    @Override
    public boolean setLastModifiedTime(long timestamp) {
        try {
            this.fileSystem.setTimes(this.path, timestamp, timestamp);
            return true;
        }
        catch (IOException e) {
            throw new CarbonFileException("Error while setting modified time: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncate(String fileName, long validDataEndOffset) {
        DataOutputStream dataOutputStream = null;
        DataInputStream dataInputStream = null;
        boolean fileTruncatedSuccessfully = false;
        int bufferSize = validDataEndOffset > 1024L ? 1024 : (int)validDataEndOffset;
        String tempWriteFilePath = fileName + ".write";
        try {
            CarbonFile tempFile;
            if (FileFactory.isFileExist(tempWriteFilePath)) {
                tempFile = FileFactory.getCarbonFile(tempWriteFilePath);
                tempFile.delete();
            }
            FileFactory.createNewFile(tempWriteFilePath);
            tempFile = FileFactory.getCarbonFile(tempWriteFilePath);
            byte[] buff = new byte[bufferSize];
            dataInputStream = FileFactory.getDataInputStream(fileName);
            int read = dataInputStream.read(buff, 0, buff.length);
            dataOutputStream = FileFactory.getDataOutputStream(tempWriteFilePath);
            dataOutputStream.write(buff, 0, read);
            for (long remaining = validDataEndOffset - (long)read; remaining > 0L; remaining -= (long)read) {
                buff = remaining > (long)bufferSize ? new byte[bufferSize] : new byte[(int)remaining];
                read = dataInputStream.read(buff, 0, buff.length);
                dataOutputStream.write(buff, 0, read);
            }
            CarbonUtil.closeStreams(dataInputStream, dataOutputStream);
            tempFile.renameForce(fileName);
            fileTruncatedSuccessfully = true;
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)("Exception occurred while truncating the file " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(dataOutputStream, dataInputStream);
                throw throwable;
            }
            CarbonUtil.closeStreams(dataOutputStream, dataInputStream);
        }
        CarbonUtil.closeStreams(dataOutputStream, dataInputStream);
        return fileTruncatedSuccessfully;
    }

    @Override
    public boolean isFileModified(long fileTimeStamp, long endOffset) {
        boolean isFileModified = false;
        if (this.getLastModifiedTime() > fileTimeStamp || this.getSize() > endOffset) {
            isFileModified = true;
        }
        return isFileModified;
    }

    @Override
    public DataOutputStream getDataOutputStream(int bufferSize, boolean append) throws IOException {
        FSDataOutputStream stream = null;
        stream = append ? (CarbonUtil.isFileExists(this.path.toString()) ? this.fileSystem.append(this.path, bufferSize) : this.fileSystem.create(this.path, true, bufferSize)) : this.fileSystem.create(this.path, true, bufferSize);
        return stream;
    }

    @Override
    public DataInputStream getDataInputStream(int bufferSize) throws IOException {
        return this.getDataInputStream(bufferSize, CarbonUtil.inferCompressorFromFileName(this.path.toString()));
    }

    @Override
    public DataInputStream getDataInputStream(int bufferSize, long offset) throws IOException {
        FSDataInputStream stream = this.fileSystem.open(this.path, bufferSize);
        stream.seek(offset);
        return new DataInputStream(new BufferedInputStream((InputStream)stream));
    }

    @Override
    public DataInputStream getDataInputStream(int bufferSize, String compressor) throws IOException {
        FSDataInputStream inputStream = bufferSize <= 0 ? this.fileSystem.open(this.path) : this.fileSystem.open(this.path, bufferSize);
        String codecName = this.getCodecNameFromCompressor(compressor);
        if (!codecName.isEmpty()) {
            CompressionCodec codec = new CompressionCodecFactory(this.hadoopConf).getCodecByName(codecName);
            inputStream = codec.createInputStream((InputStream)inputStream);
        }
        if (bufferSize <= 0 && inputStream instanceof FSDataInputStream) {
            return (DataInputStream)inputStream;
        }
        return new DataInputStream(new BufferedInputStream((InputStream)inputStream));
    }

    private String getCodecNameFromCompressor(String compressorName) throws IOException {
        if (compressorName.isEmpty()) {
            return "";
        }
        if ("GZIP".equalsIgnoreCase(compressorName)) {
            return GzipCodec.class.getName();
        }
        if ("BZIP2".equalsIgnoreCase(compressorName)) {
            return BZip2Codec.class.getName();
        }
        if ("SNAPPY".equalsIgnoreCase(compressorName)) {
            return SnappyCodec.class.getName();
        }
        if ("LZ4".equalsIgnoreCase(compressorName)) {
            return Lz4Codec.class.getName();
        }
        throw new IOException("Unsuppotted compressor: " + compressorName);
    }

    @Override
    public DataOutputStream getDataOutputStream() throws IOException {
        return this.fileSystem.create(this.path, true);
    }

    @Override
    public DataOutputStream getDataOutputStream(int bufferSize, long blockSize) throws IOException {
        short replication = this.fileSystem.getDefaultReplication(this.path);
        return this.getDataOutputStream(bufferSize, blockSize, replication);
    }

    @Override
    public DataOutputStream getDataOutputStream(int bufferSize, long blockSize, short replication) throws IOException {
        return this.fileSystem.create(this.path, true, bufferSize, replication, blockSize);
    }

    @Override
    public DataOutputStream getDataOutputStream(int bufferSize, String compressor) throws IOException {
        FSDataOutputStream outputStream = bufferSize <= 0 ? this.fileSystem.create(this.path) : this.fileSystem.create(this.path, true, bufferSize);
        String codecName = this.getCodecNameFromCompressor(compressor);
        if (!codecName.isEmpty()) {
            CompressionCodec codec = new CompressionCodecFactory(this.hadoopConf).getCodecByName(codecName);
            outputStream = codec.createOutputStream((OutputStream)outputStream);
        }
        return new DataOutputStream(new BufferedOutputStream((OutputStream)outputStream));
    }

    @Override
    public boolean isFileExist(boolean performFileCheck) throws IOException {
        if (performFileCheck) {
            return this.fileSystem.exists(this.path) && this.fileSystem.isFile(this.path);
        }
        return this.fileSystem.exists(this.path);
    }

    @Override
    public boolean isFileExist() throws IOException {
        return this.isFileExist(false);
    }

    @Override
    public boolean createNewFile(FsPermission permission) throws IOException {
        if (this.fileSystem.exists(this.path)) {
            return false;
        }
        if (permission == null) {
            permission = FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)this.fileSystem.getConf()));
        }
        this.fileSystem.create(this.path, permission, false, this.fileSystem.getConf().getInt("io.file.buffer.size", 4096), this.fileSystem.getDefaultReplication(this.path), this.fileSystem.getDefaultBlockSize(this.path), null).close();
        return true;
    }

    @Override
    public boolean deleteFile() throws IOException {
        return this.fileSystem.delete(this.path, true);
    }

    @Override
    public boolean mkdirs() throws IOException {
        return this.fileSystem.mkdirs(this.path);
    }

    @Override
    public DataOutputStream getDataOutputStreamUsingAppend() throws IOException {
        return this.fileSystem.append(this.path);
    }

    @Override
    public boolean createNewLockFile() throws IOException {
        if (this.fileSystem.exists(this.path)) {
            return false;
        }
        this.fileSystem.create(this.path, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL), false, this.fileSystem.getConf().getInt("io.file.buffer.size", 4096), this.fileSystem.getDefaultReplication(this.path), this.fileSystem.getDefaultBlockSize(this.path), null).close();
        this.fileSystem.setPermission(this.path, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        return true;
    }

    @Override
    public CarbonFile[] listFiles() {
        FileStatus[] listStatus;
        try {
            listStatus = this.fileSystem.listStatus(this.path);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Exception occured: " + e.getMessage()), (Throwable)e);
            return new CarbonFile[0];
        }
        return this.getFiles(listStatus);
    }

    protected abstract CarbonFile[] getFiles(FileStatus[] var1);

    @Override
    public List<CarbonFile> listFiles(Boolean recursive) throws IOException {
        RemoteIterator listStatus = this.fileSystem.listFiles(this.path, recursive.booleanValue());
        return this.getFiles((RemoteIterator<LocatedFileStatus>)listStatus);
    }

    @Override
    public CarbonFile[] locationAwareListFiles(PathFilter pathFilter) throws IOException {
        ArrayList<LocatedFileStatus> listStatus = new ArrayList<LocatedFileStatus>();
        RemoteIterator iter = this.fileSystem.listLocatedStatus(this.path);
        while (iter.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)iter.next();
            if (!pathFilter.accept(fileStatus.getPath()) || fileStatus.getLen() <= 0L) continue;
            listStatus.add(fileStatus);
        }
        return this.getFiles(listStatus.toArray(new FileStatus[listStatus.size()]));
    }

    protected List<CarbonFile> getFiles(RemoteIterator<LocatedFileStatus> listStatus) throws IOException {
        ArrayList<CarbonFile> carbonFiles = new ArrayList<CarbonFile>();
        while (listStatus.hasNext()) {
            Path filePath = ((LocatedFileStatus)listStatus.next()).getPath();
            carbonFiles.add(FileFactory.getCarbonFile(filePath.toString()));
        }
        return carbonFiles;
    }

    @Override
    public List<CarbonFile> listFiles(boolean recursive, CarbonFileFilter fileFilter) throws IOException {
        ArrayList<CarbonFile> carbonFiles = new ArrayList<CarbonFile>();
        FileStatus fileStatus = this.fileSystem.getFileStatus(this.path);
        if (null != fileStatus && fileStatus.isDirectory()) {
            RemoteIterator listStatus = this.fileSystem.listFiles(fileStatus.getPath(), recursive);
            while (listStatus.hasNext()) {
                LocatedFileStatus locatedFileStatus = (LocatedFileStatus)listStatus.next();
                CarbonFile carbonFile = FileFactory.getCarbonFile(locatedFileStatus.getPath().toString());
                if (!fileFilter.accept(carbonFile)) continue;
                carbonFiles.add(carbonFile);
            }
        }
        return carbonFiles;
    }

    @Override
    public CarbonFile[] listFiles(boolean recursive, int maxCount) throws IOException {
        ArrayList<CarbonFile> carbonFiles = new ArrayList<CarbonFile>();
        FileStatus fileStatus = this.fileSystem.getFileStatus(this.path);
        if (null != fileStatus && fileStatus.isDirectory()) {
            RemoteIterator listStatus = this.fileSystem.listFiles(this.path, recursive);
            for (int counter = 0; counter < maxCount && listStatus.hasNext(); ++counter) {
                LocatedFileStatus locatedFileStatus = (LocatedFileStatus)listStatus.next();
                CarbonFile carbonFile = FileFactory.getCarbonFile(locatedFileStatus.getPath().toString());
                carbonFiles.add(carbonFile);
            }
        }
        return carbonFiles.toArray(new CarbonFile[0]);
    }

    @Override
    public String[] getLocations() throws IOException {
        FileStatus fileStatus = this.fileSystem.getFileStatus(this.path);
        BlockLocation[] blkLocations = fileStatus instanceof LocatedFileStatus ? ((LocatedFileStatus)fileStatus).getBlockLocations() : this.fileSystem.getFileBlockLocations(fileStatus.getPath(), 0L, fileStatus.getLen());
        return blkLocations[0].getHosts();
    }

    @Override
    public boolean setReplication(short replication) throws IOException {
        return this.fileSystem.setReplication(this.path, replication);
    }

    @Override
    public CarbonFile[] listFiles(CarbonFileFilter fileFilter) {
        CarbonFile[] files = this.listFiles();
        if (files != null && files.length >= 1) {
            ArrayList<CarbonFile> fileList = new ArrayList<CarbonFile>(files.length);
            for (int i = 0; i < files.length; ++i) {
                if (!fileFilter.accept(files[i])) continue;
                fileList.add(files[i]);
            }
            if (fileList.size() >= 1) {
                return fileList.toArray(new CarbonFile[fileList.size()]);
            }
            return new CarbonFile[0];
        }
        return files;
    }

    @Override
    public short getDefaultReplication() {
        return this.fileSystem.getDefaultReplication(this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDFSCarbonFile that = (AbstractDFSCarbonFile)o;
        if (this.path == null || that.path == null) {
            return false;
        }
        return this.path.equals((Object)that.path);
    }

    public int hashCode() {
        if (this.path == null) {
            return 0;
        }
        return Objects.hash(this.path);
    }

    @Override
    public long getLength() throws IOException {
        return this.fileSystem.getFileStatus(this.path).getLen();
    }
}

