/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.filesystem;

import java.io.IOException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.HDFSCarbonFile;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.log4j.Logger;

public class AlluxioCarbonFile
extends HDFSCarbonFile {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)AlluxioCarbonFile.class.getName());

    public AlluxioCarbonFile(String filePath) {
        super(filePath);
    }

    public AlluxioCarbonFile(Path path) {
        super(path);
    }

    public AlluxioCarbonFile(FileStatus fileStatus) {
        super(fileStatus);
    }

    @Override
    protected CarbonFile[] getFiles(FileStatus[] listStatus) {
        if (listStatus == null) {
            return new CarbonFile[0];
        }
        CarbonFile[] files = new CarbonFile[listStatus.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new AlluxioCarbonFile(listStatus[i]);
        }
        return files;
    }

    @Override
    public String getAbsolutePath() {
        String absolutePath = super.getAbsolutePath();
        return AlluxioCarbonFile.getFormattedPath(absolutePath);
    }

    public static String getFormattedPath(String absolutePath) {
        if (absolutePath.startsWith("alluxio:/") && absolutePath.charAt(9) != '/') {
            return absolutePath.replace("alluxio:/", "alluxio:///");
        }
        return absolutePath;
    }

    @Override
    public boolean renameForce(String changetoName) {
        try {
            if (this.fileSystem instanceof DistributedFileSystem) {
                ((DistributedFileSystem)this.fileSystem).rename(this.path, new Path(changetoName), new Options.Rename[]{Options.Rename.OVERWRITE});
                return true;
            }
            return false;
        }
        catch (IOException e) {
            LOGGER.error((Object)("Exception occured: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }
}

