/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.filesystem;

import java.io.IOException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.AbstractDFSCarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.log4j.Logger;

public class HDFSCarbonFile
extends AbstractDFSCarbonFile {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)HDFSCarbonFile.class.getName());

    public HDFSCarbonFile(String filePath) {
        super(filePath);
    }

    public HDFSCarbonFile(String filePath, Configuration hadoopConf) {
        super(filePath, hadoopConf);
    }

    public HDFSCarbonFile(Path path) {
        super(path);
    }

    public HDFSCarbonFile(Path path, Configuration hadoopConf) {
        super(path, hadoopConf);
    }

    public HDFSCarbonFile(FileStatus fileStatus) {
        super(fileStatus);
    }

    @Override
    protected CarbonFile[] getFiles(FileStatus[] listStatus) {
        if (listStatus == null) {
            return new CarbonFile[0];
        }
        CarbonFile[] files = new CarbonFile[listStatus.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new HDFSCarbonFile(listStatus[i]);
        }
        return files;
    }

    @Override
    public boolean renameForce(String changetoName) {
        try {
            if (this.fileSystem instanceof DistributedFileSystem) {
                ((DistributedFileSystem)this.fileSystem).rename(this.path, new Path(changetoName), new Options.Rename[]{Options.Rename.OVERWRITE});
                return true;
            }
            if (this.fileSystem instanceof FilterFileSystem && ((FilterFileSystem)this.fileSystem).getRawFileSystem() instanceof DistributedFileSystem) {
                ((DistributedFileSystem)((FilterFileSystem)this.fileSystem).getRawFileSystem()).rename(this.path, new Path(changetoName), new Options.Rename[]{Options.Rename.OVERWRITE});
                return true;
            }
            return this.fileSystem.rename(this.path, new Path(changetoName));
        }
        catch (IOException e) {
            LOGGER.error((Object)("Exception occured: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }
}

