/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.filesystem;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class LocalCarbonFile
implements CarbonFile {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)LocalCarbonFile.class.getName());
    private File file;
    private String absoluteFilePath;

    public LocalCarbonFile(String filePath) {
        Path pathWithoutSchemeAndAuthority = Path.getPathWithoutSchemeAndAuthority((Path)new Path(filePath));
        filePath = pathWithoutSchemeAndAuthority.toString().replace("\\", "/");
        this.absoluteFilePath = FileFactory.getUpdatedFilePath(filePath);
        this.file = new File(this.absoluteFilePath);
    }

    LocalCarbonFile(File file) {
        this.file = file;
        String filePath = file.getAbsolutePath().replace("\\", "/");
        this.absoluteFilePath = FileFactory.getUpdatedFilePath(filePath);
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public CarbonFile[] listFiles(CarbonFileFilter fileFilter) {
        if (!this.isDirectory()) {
            return new CarbonFile[0];
        }
        File[] files = this.file.listFiles((File pathname) -> fileFilter.accept(new LocalCarbonFile(pathname)));
        if (files == null) {
            return new CarbonFile[0];
        }
        CarbonFile[] carbonFiles = new CarbonFile[files.length];
        for (int i = 0; i < carbonFiles.length; ++i) {
            carbonFiles[i] = new LocalCarbonFile(files[i]);
        }
        return carbonFiles;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public String getCanonicalPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error((Object)("Exception occured" + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public CarbonFile getParentFile() {
        return new LocalCarbonFile(this.file.getParentFile());
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public boolean renameTo(String changetoName) {
        changetoName = FileFactory.getUpdatedFilePath(changetoName);
        return this.file.renameTo(new File(changetoName));
    }

    @Override
    public boolean delete() {
        return this.deleteFile();
    }

    @Override
    public CarbonFile[] listFiles() {
        if (!this.file.isDirectory()) {
            return new CarbonFile[0];
        }
        File[] files = this.file.listFiles();
        if (files == null) {
            return new CarbonFile[0];
        }
        CarbonFile[] carbonFiles = new CarbonFile[files.length];
        for (int i = 0; i < carbonFiles.length; ++i) {
            carbonFiles[i] = new LocalCarbonFile(files[i]);
        }
        return carbonFiles;
    }

    @Override
    public CarbonFile[] listFiles(boolean recursive, int maxCount) throws IOException {
        return this.listFiles();
    }

    @Override
    public List<CarbonFile> listFiles(Boolean recursive) {
        if (!this.isDirectory()) {
            return new ArrayList<CarbonFile>();
        }
        Collection fileCollection = FileUtils.listFiles((File)this.file, null, (boolean)true);
        ArrayList<CarbonFile> carbonFiles = new ArrayList<CarbonFile>();
        for (File file : fileCollection) {
            carbonFiles.add(new LocalCarbonFile(file));
        }
        return carbonFiles;
    }

    @Override
    public List<CarbonFile> listFiles(boolean recursive, CarbonFileFilter fileFilter) {
        if (!this.file.isDirectory()) {
            return new ArrayList<CarbonFile>();
        }
        Collection fileCollection = FileUtils.listFiles((File)this.file, null, (boolean)recursive);
        if (fileCollection.isEmpty()) {
            return new ArrayList<CarbonFile>();
        }
        ArrayList<CarbonFile> carbonFiles = new ArrayList<CarbonFile>();
        for (File file : fileCollection) {
            LocalCarbonFile carbonFile = new LocalCarbonFile(file);
            if (!fileFilter.accept(carbonFile)) continue;
            carbonFiles.add(carbonFile);
        }
        return carbonFiles;
    }

    @Override
    public boolean createNewFile() {
        try {
            return this.file.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public long getLastModifiedTime() {
        return this.file.lastModified();
    }

    @Override
    public boolean setLastModifiedTime(long timestamp) {
        return this.file.setLastModified(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncate(String fileName, long validDataEndOffset) {
        FileChannel source = null;
        FileChannel destination = null;
        boolean fileTruncatedSuccessfully = false;
        String tempWriteFilePath = fileName + ".write";
        try {
            long read;
            CarbonFile tempFile;
            if (this.isFileExist()) {
                tempFile = FileFactory.getCarbonFile(tempWriteFilePath);
                tempFile.delete();
            }
            FileFactory.createNewFile(tempWriteFilePath);
            tempFile = FileFactory.getCarbonFile(tempWriteFilePath);
            source = new FileInputStream(fileName).getChannel();
            destination = new FileOutputStream(tempWriteFilePath).getChannel();
            long totalBytesRead = read = destination.transferFrom(source, 0L, validDataEndOffset);
            for (long remaining = validDataEndOffset - totalBytesRead; remaining > 0L; remaining -= (totalBytesRead += read)) {
                read = destination.transferFrom(source, totalBytesRead, remaining);
            }
            CarbonUtil.closeStreams(source, destination);
            tempFile.renameForce(fileName);
            fileTruncatedSuccessfully = true;
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)("Exception occured while truncating the file " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(source, destination);
                throw throwable;
            }
            CarbonUtil.closeStreams(source, destination);
        }
        CarbonUtil.closeStreams(source, destination);
        return fileTruncatedSuccessfully;
    }

    @Override
    public boolean isFileModified(long fileTimeStamp, long endOffset) {
        boolean isFileModified = false;
        if (this.getLastModifiedTime() > fileTimeStamp || this.getSize() > endOffset) {
            isFileModified = true;
        }
        return isFileModified;
    }

    @Override
    public boolean renameForce(String changeToName) {
        File destFile = new File(changeToName);
        if (destFile.exists() && !this.file.getAbsolutePath().equals(destFile.getAbsolutePath()) && destFile.delete()) {
            return this.file.renameTo(new File(changeToName));
        }
        return this.file.renameTo(new File(changeToName));
    }

    @Override
    public DataOutputStream getDataOutputStream(int bufferSize, boolean append) throws FileNotFoundException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.absoluteFilePath, append), bufferSize));
    }

    @Override
    public DataInputStream getDataInputStream(int bufferSize) throws IOException {
        return this.getDataInputStream(bufferSize, CarbonUtil.inferCompressorFromFileName(this.file.getAbsolutePath()));
    }

    @Override
    public DataInputStream getDataInputStream(int bufferSize, String compressor) throws IOException {
        InputStream inputStream;
        if (compressor.isEmpty()) {
            inputStream = new FileInputStream(this.absoluteFilePath);
        } else if ("GZIP".equalsIgnoreCase(compressor)) {
            inputStream = new GZIPInputStream(new FileInputStream(this.absoluteFilePath));
        } else if ("BZIP2".equalsIgnoreCase(compressor)) {
            inputStream = new BZip2CompressorInputStream((InputStream)new FileInputStream(this.absoluteFilePath));
        } else if ("SNAPPY".equalsIgnoreCase(compressor)) {
            inputStream = new SnappyInputStream((InputStream)new FileInputStream(this.absoluteFilePath));
        } else if ("LZ4".equalsIgnoreCase(compressor)) {
            inputStream = new LZ4BlockInputStream((InputStream)new FileInputStream(this.absoluteFilePath));
        } else if ("ZSTD".equalsIgnoreCase(compressor)) {
            inputStream = new ZstdInputStream((InputStream)new FileInputStream(this.absoluteFilePath));
        } else {
            throw new IOException("Unsupported compressor: " + compressor);
        }
        if (bufferSize <= 0) {
            return new DataInputStream(new BufferedInputStream(inputStream));
        }
        return new DataInputStream(new BufferedInputStream(inputStream, bufferSize));
    }

    @Override
    public DataInputStream getDataInputStream(int bufferSize, long offset) throws IOException {
        FileInputStream fis = new FileInputStream(this.absoluteFilePath);
        long actualSkipSize = 0L;
        long skipSize = offset;
        try {
            while (actualSkipSize != offset) {
                skipSize -= (actualSkipSize += fis.skip(skipSize));
            }
        }
        catch (IOException ioe) {
            CarbonUtil.closeStream(fis);
            throw ioe;
        }
        return new DataInputStream(new BufferedInputStream(fis));
    }

    @Override
    public DataOutputStream getDataOutputStream() throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.absoluteFilePath)));
    }

    @Override
    public DataOutputStream getDataOutputStream(int bufferSize, long blockSize) throws IOException {
        return this.getDataOutputStream(bufferSize, blockSize, (short)1);
    }

    @Override
    public DataOutputStream getDataOutputStream(int bufferSize, long blockSize, short replication) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.absoluteFilePath), bufferSize));
    }

    @Override
    public DataOutputStream getDataOutputStream(int bufferSize, String compressor) throws IOException {
        OutputStream outputStream;
        if (compressor.isEmpty()) {
            outputStream = new FileOutputStream(this.absoluteFilePath);
        } else if ("GZIP".equalsIgnoreCase(compressor)) {
            outputStream = new GZIPOutputStream(new FileOutputStream(this.absoluteFilePath));
        } else if ("BZIP2".equalsIgnoreCase(compressor)) {
            outputStream = new BZip2CompressorOutputStream((OutputStream)new FileOutputStream(this.absoluteFilePath));
        } else if ("SNAPPY".equalsIgnoreCase(compressor)) {
            outputStream = new SnappyOutputStream((OutputStream)new FileOutputStream(this.absoluteFilePath));
        } else if ("LZ4".equalsIgnoreCase(compressor)) {
            outputStream = new LZ4BlockOutputStream((OutputStream)new FileOutputStream(this.absoluteFilePath));
        } else if ("ZSTD".equalsIgnoreCase(compressor)) {
            outputStream = new ZstdOutputStream((OutputStream)new FileOutputStream(this.absoluteFilePath), 1);
        } else {
            throw new IOException("Unsupported compressor: " + compressor);
        }
        if (bufferSize <= 0) {
            return new DataOutputStream(new BufferedOutputStream(outputStream));
        }
        return new DataOutputStream(new BufferedOutputStream(outputStream, bufferSize));
    }

    @Override
    public boolean isFileExist(boolean performFileCheck) {
        if (performFileCheck) {
            return this.file.exists() && this.file.isFile();
        }
        return this.file.exists();
    }

    @Override
    public boolean isFileExist() {
        return this.file.exists();
    }

    @Override
    public boolean createNewFile(FsPermission permission) throws IOException {
        return this.file.createNewFile();
    }

    @Override
    public boolean deleteFile() {
        return FileFactory.deleteAllFilesOfDir(this.file);
    }

    @Override
    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    @Override
    public DataOutputStream getDataOutputStreamUsingAppend() throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.absoluteFilePath, true)));
    }

    @Override
    public boolean createNewLockFile() throws IOException {
        return this.file.createNewFile();
    }

    @Override
    public CarbonFile[] locationAwareListFiles(PathFilter pathFilter) {
        return this.listFiles();
    }

    @Override
    public String[] getLocations() {
        return new String[]{"localhost"};
    }

    @Override
    public boolean setReplication(short replication) {
        return true;
    }

    @Override
    public short getDefaultReplication() {
        return 1;
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalCarbonFile that = (LocalCarbonFile)o;
        return Objects.equals(this.file.getAbsolutePath(), that.file.getAbsolutePath());
    }

    public int hashCode() {
        return Objects.hash(this.file.getAbsolutePath());
    }
}

