/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.filesystem;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.HDFSCarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class S3CarbonFile
extends HDFSCarbonFile {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)HDFSCarbonFile.class.getName());

    public S3CarbonFile(String filePath) {
        super(filePath);
    }

    public S3CarbonFile(FileStatus fileStatus) {
        super(fileStatus);
    }

    public S3CarbonFile(String filePath, Configuration hadoopConf) {
        super(filePath, hadoopConf);
    }

    @Override
    public boolean renameForce(String changetoName) {
        try {
            CarbonFile newCarbonFile = FileFactory.getCarbonFile(changetoName);
            newCarbonFile.delete();
            return this.fileSystem.rename(this.path, new Path(changetoName));
        }
        catch (IOException e) {
            LOGGER.error((Object)("Exception occured: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    protected CarbonFile[] getFiles(FileStatus[] listStatus) {
        if (listStatus == null) {
            return new CarbonFile[0];
        }
        CarbonFile[] files = new CarbonFile[listStatus.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new S3CarbonFile(listStatus[i]);
        }
        return files;
    }

    @Override
    public DataOutputStream getDataOutputStreamUsingAppend() throws IOException {
        return this.getDataOutputStream(24576, true);
    }

    @Override
    public DataOutputStream getDataOutputStream(int bufferSize, boolean append) throws IOException {
        FSDataOutputStream stream;
        if (append) {
            if (CarbonUtil.isFileExists(this.getAbsolutePath())) {
                FSDataInputStream dataInputStream = this.fileSystem.open(this.path);
                int count = dataInputStream.available();
                byte[] byteStreamBuffer = new byte[count];
                int bytesRead = dataInputStream.read(byteStreamBuffer);
                dataInputStream.close();
                stream = this.fileSystem.create(this.path, true, bufferSize);
                stream.write(byteStreamBuffer, 0, bytesRead);
            } else {
                stream = this.fileSystem.create(this.path, true, bufferSize);
            }
        } else {
            stream = this.fileSystem.create(this.path, true, bufferSize);
        }
        return stream;
    }
}

