/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.filesystem;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.AbstractDFSCarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.log4j.Logger;

public class ViewFSCarbonFile
extends AbstractDFSCarbonFile {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)ViewFSCarbonFile.class.getName());

    public ViewFSCarbonFile(String filePath) {
        super(filePath);
    }

    public ViewFSCarbonFile(FileStatus fileStatus) {
        super(fileStatus);
    }

    @Override
    protected CarbonFile[] getFiles(FileStatus[] listStatus) {
        if (listStatus == null) {
            return new CarbonFile[0];
        }
        CarbonFile[] files = new CarbonFile[listStatus.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new ViewFSCarbonFile(listStatus[i]);
        }
        return files;
    }

    @Override
    public CarbonFile[] listFiles(CarbonFileFilter fileFilter) {
        CarbonFile[] files = this.listFiles();
        if (files != null && files.length >= 1) {
            ArrayList<CarbonFile> fileList = new ArrayList<CarbonFile>(files.length);
            for (CarbonFile file : files) {
                if (!fileFilter.accept(file)) continue;
                fileList.add(file);
            }
            if (fileList.size() >= 1) {
                return fileList.toArray(new CarbonFile[fileList.size()]);
            }
            return new CarbonFile[0];
        }
        return files;
    }

    @Override
    public boolean renameForce(String changeToName) {
        try {
            if (this.fileSystem instanceof ViewFileSystem) {
                this.fileSystem.delete(new Path(changeToName), true);
                this.fileSystem.rename(this.path, new Path(changeToName));
                return true;
            }
            LOGGER.warn((Object)("Unrecognized file system for path: " + this.path));
            return false;
        }
        catch (IOException e) {
            LOGGER.error((Object)("Exception occured" + e.getMessage()), (Throwable)e);
            return false;
        }
    }
}

