/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DFSFileReaderImpl
implements FileReader {
    protected Map<String, FSDataInputStream> fileNameAndStreamCache;
    private boolean readPageByPage;
    private Configuration configuration;

    public DFSFileReaderImpl(Configuration configuration) {
        this.configuration = configuration;
        this.fileNameAndStreamCache = new HashMap<String, FSDataInputStream>(16);
    }

    @Override
    public byte[] readByteArray(String filePath, long offset, int length) throws IOException {
        FSDataInputStream fileChannel = this.updateCache(filePath);
        return this.read(fileChannel, length, offset);
    }

    public FSDataInputStream updateCache(String filePath) throws IOException {
        FSDataInputStream fileChannel = this.fileNameAndStreamCache.get(filePath);
        if (null == fileChannel) {
            Path pt = new Path(filePath);
            FileSystem fs = pt.getFileSystem(this.configuration);
            fileChannel = fs.open(pt);
            this.fileNameAndStreamCache.put(filePath, fileChannel);
        }
        return fileChannel;
    }

    private byte[] read(FSDataInputStream channel, int size, long offset) throws IOException {
        byte[] byteBuffer = new byte[size];
        channel.seek(offset);
        channel.readFully(byteBuffer);
        return byteBuffer;
    }

    private byte[] read(FSDataInputStream channel, int size) throws IOException {
        byte[] byteBuffer = new byte[size];
        channel.readFully(byteBuffer);
        return byteBuffer;
    }

    @Override
    public int readInt(String filePath, long offset) throws IOException {
        FSDataInputStream fileChannel = this.updateCache(filePath);
        fileChannel.seek(offset);
        return fileChannel.readInt();
    }

    @Override
    public long readDouble(String filePath, long offset) throws IOException {
        FSDataInputStream fileChannel = this.updateCache(filePath);
        fileChannel.seek(offset);
        return fileChannel.readLong();
    }

    @Override
    public void finish() throws IOException {
        for (Map.Entry<String, FSDataInputStream> entry : this.fileNameAndStreamCache.entrySet()) {
            FSDataInputStream channel = entry.getValue();
            if (null == channel) continue;
            channel.close();
        }
    }

    @Override
    public byte[] readByteArray(String filePath, int length) throws IOException {
        FSDataInputStream fileChannel = this.updateCache(filePath);
        return this.read(fileChannel, length);
    }

    @Override
    public long readLong(String filePath, long offset) throws IOException {
        FSDataInputStream fileChannel = this.updateCache(filePath);
        fileChannel.seek(offset);
        return fileChannel.readLong();
    }

    @Override
    public int readInt(String filePath) throws IOException {
        FSDataInputStream fileChannel = this.updateCache(filePath);
        return fileChannel.readInt();
    }

    @Override
    public ByteBuffer readByteBuffer(String filePath, long offset, int length) throws IOException {
        byte[] readByteArray = this.readByteArray(filePath, offset, length);
        ByteBuffer byteBuffer = ByteBuffer.wrap(readByteArray);
        byteBuffer.rewind();
        return byteBuffer;
    }

    @Override
    public void setReadPageByPage(boolean isReadPageByPage) {
        this.readPageByPage = isReadPageByPage;
    }

    @Override
    public boolean isReadPageByPage() {
        return this.readPageByPage;
    }

    public Map<String, FSDataInputStream> getFileNameAndStreamCache() {
        return this.fileNameAndStreamCache;
    }
}

