/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.impl;

import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.AlluxioCarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.HDFSCarbonFile;
import org.apache.carbondata.core.datastore.filesystem.LocalCarbonFile;
import org.apache.carbondata.core.datastore.filesystem.S3CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.ViewFSCarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.datastore.impl.FileTypeInterface;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class DefaultFileTypeProvider
implements FileTypeInterface {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)DefaultFileTypeProvider.class.getName());
    protected FileTypeInterface customFileTypeProvider = null;
    protected Boolean customFileTypeProviderInitialized = false;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCustomFileProvider() {
        if (!this.customFileTypeProviderInitialized.booleanValue()) {
            Object object = this.lock;
            synchronized (object) {
                String customFileProvider;
                if (!this.customFileTypeProviderInitialized.booleanValue() && (customFileProvider = CarbonProperties.getInstance().getProperty("carbon.fs.custom.file.provider")) != null && !customFileProvider.trim().isEmpty()) {
                    try {
                        this.customFileTypeProvider = (FileTypeInterface)Class.forName(customFileProvider).newInstance();
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"Unable load configured FileTypeInterface class. Ignored.", (Throwable)e);
                    }
                    this.customFileTypeProviderInitialized = true;
                }
            }
        }
    }

    @Override
    public boolean isPathSupported(String path) {
        this.initializeCustomFileProvider();
        if (this.customFileTypeProvider != null) {
            return this.customFileTypeProvider.isPathSupported(path);
        }
        return false;
    }

    @Override
    public CarbonFile getCarbonFile(String path, Configuration conf) {
        if (this.isPathSupported(path)) {
            return this.customFileTypeProvider.getCarbonFile(path, conf);
        }
        FileFactory.FileType fileType = FileFactory.getFileType(path);
        switch (fileType) {
            case LOCAL: {
                return new LocalCarbonFile(FileFactory.getUpdatedFilePath(path));
            }
            case HDFS: 
            case HDFS_LOCAL: {
                return new HDFSCarbonFile(path, conf);
            }
            case S3: {
                return new S3CarbonFile(path, conf);
            }
            case ALLUXIO: {
                return new AlluxioCarbonFile(path);
            }
            case VIEWFS: {
                return new ViewFSCarbonFile(path);
            }
        }
        return new LocalCarbonFile(FileFactory.getUpdatedFilePath(path));
    }
}

