/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.filesystem.AlluxioCarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.DFSFileReaderImpl;
import org.apache.carbondata.core.datastore.impl.DefaultFileTypeProvider;
import org.apache.carbondata.core.datastore.impl.FileReaderImpl;
import org.apache.carbondata.core.fileoperations.AtomicFileOperationFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperations;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;

public final class FileFactory {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)FileFactory.class.getName());
    private static Configuration configuration = new Configuration();
    private static DefaultFileTypeProvider fileFileTypeInterface;

    public static void setFileTypeInterface(DefaultFileTypeProvider fileTypeInterface) {
        fileFileTypeInterface = fileTypeInterface;
    }

    private FileFactory() {
    }

    public static Configuration getConfiguration() {
        Object confObject = ThreadLocalSessionInfo.getOrCreateCarbonSessionInfo().getNonSerializableExtraInfo().get("carbonConf");
        Configuration conf = confObject == null ? configuration : (Configuration)confObject;
        return conf;
    }

    public static FileReader getFileHolder(FileType fileType) {
        return FileFactory.getFileHolder(fileType, FileFactory.getConfiguration());
    }

    public static FileReader getFileHolder(FileType fileType, Configuration configuration) {
        switch (fileType) {
            case LOCAL: {
                return new FileReaderImpl();
            }
            case HDFS: 
            case ALLUXIO: 
            case VIEWFS: 
            case S3: 
            case HDFS_LOCAL: {
                return new DFSFileReaderImpl(configuration);
            }
        }
        return new FileReaderImpl();
    }

    public static FileType getFileType(String path) {
        FileType fileType = FileFactory.getFileTypeWithActualPath(path);
        if (fileType != null) {
            return fileType;
        }
        fileType = FileFactory.getFileTypeWithLowerCase(path);
        if (fileType != null) {
            return fileType;
        }
        if (fileFileTypeInterface.isPathSupported(path)) {
            return FileType.CUSTOM;
        }
        if (path.contains("://") && !path.startsWith("file://")) {
            throw new IllegalArgumentException("Path belongs to unsupported file system " + path);
        }
        return FileType.LOCAL;
    }

    private static FileType getFileTypeWithLowerCase(String path) {
        String lowerCase = path.toLowerCase();
        if (lowerCase.startsWith("hdfs://")) {
            return FileType.HDFS;
        }
        if (lowerCase.startsWith("alluxio://")) {
            return FileType.ALLUXIO;
        }
        if (lowerCase.startsWith("viewfs://")) {
            return FileType.VIEWFS;
        }
        if (lowerCase.startsWith("s3n://") || lowerCase.startsWith("s3a://") || lowerCase.startsWith("s3://")) {
            return FileType.S3;
        }
        if (lowerCase.startsWith("file://") && !configuration.get("fs.defaultFS").equalsIgnoreCase("file:///")) {
            return FileType.HDFS_LOCAL;
        }
        return null;
    }

    private static FileType getFileTypeWithActualPath(String path) {
        if (path.startsWith("hdfs://")) {
            return FileType.HDFS;
        }
        if (path.startsWith("alluxio://")) {
            return FileType.ALLUXIO;
        }
        if (path.startsWith("viewfs://")) {
            return FileType.VIEWFS;
        }
        if (path.startsWith("s3n://") || path.startsWith("s3a://") || path.startsWith("s3://")) {
            return FileType.S3;
        }
        if (path.startsWith("file://") && !configuration.get("fs.defaultFS").equalsIgnoreCase("file:///")) {
            return FileType.HDFS_LOCAL;
        }
        return null;
    }

    public static CarbonFile getCarbonFile(String path) {
        return fileFileTypeInterface.getCarbonFile(path, FileFactory.getConfiguration());
    }

    public static String getFormattedPath(String path) {
        if (FileFactory.getFileType(path) == FileType.ALLUXIO) {
            return AlluxioCarbonFile.getFormattedPath(path);
        }
        return path;
    }

    public static CarbonFile getCarbonFile(String path, Configuration hadoopConf) {
        return fileFileTypeInterface.getCarbonFile(path, hadoopConf);
    }

    public static DataInputStream getDataInputStream(String path) throws IOException {
        return FileFactory.getDataInputStream(path, -1);
    }

    public static DataInputStream getDataInputStream(String path, Configuration configuration) throws IOException {
        return FileFactory.getDataInputStream(path, -1, configuration);
    }

    public static DataInputStream getDataInputStream(String path, int bufferSize) throws IOException {
        return FileFactory.getDataInputStream(path, bufferSize, FileFactory.getConfiguration());
    }

    public static DataInputStream getDataInputStream(String path, int bufferSize, Configuration configuration) throws IOException {
        return FileFactory.getCarbonFile(path, configuration).getDataInputStream(bufferSize);
    }

    public static DataInputStream getDataInputStream(String path, int bufferSize, String compressorName) throws IOException {
        return FileFactory.getCarbonFile(path).getDataInputStream(bufferSize, compressorName);
    }

    public static DataInputStream getDataInputStream(String path, int bufferSize, long offset) throws IOException {
        return FileFactory.getCarbonFile(path).getDataInputStream(bufferSize, offset);
    }

    public static DataOutputStream getDataOutputStream(String path) throws IOException {
        return FileFactory.getCarbonFile(path).getDataOutputStream();
    }

    public static DataOutputStream getDataOutputStream(String path, int bufferSize, boolean append) throws IOException {
        return FileFactory.getCarbonFile(path).getDataOutputStream(bufferSize, append);
    }

    public static DataOutputStream getDataOutputStream(String path, int bufferSize, long blockSize) throws IOException {
        return FileFactory.getCarbonFile(path).getDataOutputStream(bufferSize, blockSize);
    }

    public static DataOutputStream getDataOutputStream(String path, int bufferSize, long blockSize, short replication) throws IOException {
        return FileFactory.getCarbonFile(path).getDataOutputStream(bufferSize, blockSize, replication);
    }

    public static DataOutputStream getDataOutputStream(String path, int bufferSize, String compressorName) throws IOException {
        return FileFactory.getCarbonFile(path).getDataOutputStream(bufferSize, compressorName);
    }

    public static boolean isFileExist(String filePath, boolean performFileCheck) throws IOException {
        return FileFactory.getCarbonFile(filePath).isFileExist(performFileCheck);
    }

    public static boolean isFileExist(String filePath) throws IOException {
        return FileFactory.getCarbonFile(filePath).isFileExist();
    }

    public static boolean createNewFile(String filePath) throws IOException {
        return FileFactory.createNewFile(filePath, null);
    }

    public static boolean createNewFile(String filePath, FsPermission permission) throws IOException {
        return FileFactory.getCarbonFile(filePath).createNewFile(permission);
    }

    public static boolean deleteFile(String filePath) throws IOException {
        return FileFactory.getCarbonFile(filePath).deleteFile();
    }

    public static boolean deleteAllFilesOfDir(File path) {
        if (!path.exists()) {
            return true;
        }
        if (path.isFile()) {
            return path.delete();
        }
        File[] files = path.listFiles();
        if (null == files) {
            return true;
        }
        for (int i = 0; i < files.length; ++i) {
            FileFactory.deleteAllFilesOfDir(files[i]);
        }
        return path.delete();
    }

    public static boolean deleteAllCarbonFilesOfDir(CarbonFile path) {
        if (!path.exists()) {
            return true;
        }
        if (!path.isDirectory()) {
            return path.delete();
        }
        CarbonFile[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            FileFactory.deleteAllCarbonFilesOfDir(files[i]);
        }
        return path.delete();
    }

    public static boolean mkdirs(String filePath) throws IOException {
        return FileFactory.getCarbonFile(filePath).mkdirs();
    }

    public static boolean mkdirs(String filePath, Configuration configuration) throws IOException {
        return FileFactory.getCarbonFile(filePath, configuration).mkdirs();
    }

    public static DataOutputStream getDataOutputStreamUsingAppend(String path) throws IOException {
        return FileFactory.getCarbonFile(path).getDataOutputStreamUsingAppend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateFile(String path, long newSize) throws IOException {
        path = path.replace("\\", "/");
        FileChannel fileChannel = null;
        switch (FileFactory.getFileType(path)) {
            case LOCAL: {
                path = FileFactory.getUpdatedFilePath(path);
                fileChannel = new FileOutputStream(path, true).getChannel();
                try {
                    fileChannel.truncate(newSize);
                }
                finally {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                }
                return;
            }
            case HDFS: 
            case ALLUXIO: 
            case VIEWFS: 
            case S3: 
            case CUSTOM: {
                try {
                    Path pt = new Path(path);
                    FileSystem fs = pt.getFileSystem(FileFactory.getConfiguration());
                    Method truncateMethod = fs.getClass().getDeclaredMethod("truncate", Path.class, Long.TYPE);
                    truncateMethod.invoke((Object)fs, pt, newSize);
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error((Object)"the version of hadoop is below 2.7, there is no 'truncate' method in FileSystem, It needs to use 'CarbonFile.truncate'.");
                    CarbonFile carbonFile = FileFactory.getCarbonFile(path);
                    carbonFile.truncate(path, newSize);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Other exception occurred while truncating the file " + e.getMessage()), (Throwable)e);
                }
                return;
            }
        }
        fileChannel = new FileOutputStream(path, true).getChannel();
        try {
            fileChannel.truncate(newSize);
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
        }
    }

    public static boolean createNewLockFile(String filePath) throws IOException {
        return FileFactory.getCarbonFile(filePath).createNewLockFile();
    }

    public static String addSchemeIfNotExists(String filePath) {
        FileType fileType = FileFactory.getFileType(filePath);
        switch (fileType) {
            case LOCAL: {
                if (filePath.startsWith("file:")) {
                    return filePath;
                }
                return new Path("file://" + filePath).toString();
            }
        }
        return filePath;
    }

    public static String getUpdatedFilePath(String filePath) {
        switch (FileFactory.getFileType(filePath)) {
            case HDFS: 
            case VIEWFS: 
            case S3: 
            case HDFS_LOCAL: 
            case CUSTOM: {
                return filePath;
            }
            case ALLUXIO: {
                return StringUtils.startsWith((String)filePath, (String)"alluxio") ? filePath : "alluxio:///" + filePath;
            }
        }
        if (filePath != null && !filePath.isEmpty()) {
            if (filePath.startsWith("./")) {
                try {
                    return new File(filePath).getCanonicalPath();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            Path pathWithoutSchemeAndAuthority = Path.getPathWithoutSchemeAndAuthority((Path)new Path(filePath));
            return pathWithoutSchemeAndAuthority.toString();
        }
        return filePath;
    }

    public static long getDirectorySize(String filePath) throws IOException {
        FileType fileType = FileFactory.getFileType(filePath);
        switch (fileType) {
            case HDFS: 
            case ALLUXIO: 
            case VIEWFS: 
            case S3: 
            case HDFS_LOCAL: 
            case CUSTOM: {
                Path path = new Path(filePath);
                FileSystem fs = path.getFileSystem(FileFactory.getConfiguration());
                return fs.getContentSummary(path).getLength();
            }
        }
        filePath = FileFactory.getUpdatedFilePath(filePath);
        File file = new File(filePath);
        return FileUtils.sizeOfDirectory((File)file);
    }

    public static Path getPath(String filePath) {
        return new Path(filePath);
    }

    public static FileSystem getFileSystem(Path path) throws IOException {
        return path.getFileSystem(FileFactory.getConfiguration());
    }

    public static void createDirectoryAndSetPermission(String directoryPath, FsPermission permission) throws IOException {
        FileType fileType = FileFactory.getFileType(directoryPath);
        switch (fileType) {
            case HDFS: 
            case ALLUXIO: 
            case VIEWFS: 
            case S3: 
            case HDFS_LOCAL: 
            case CUSTOM: {
                try {
                    Path path = new Path(directoryPath);
                    FileSystem fs = path.getFileSystem(FileFactory.getConfiguration());
                    if (!fs.exists(path)) {
                        fs.mkdirs(path);
                        fs.setPermission(path, permission);
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Exception occurred : " + e.getMessage()), (Throwable)e);
                    throw e;
                }
                return;
            }
        }
        directoryPath = FileFactory.getUpdatedFilePath(directoryPath);
        File file = new File(directoryPath);
        if (!file.mkdirs()) {
            LOGGER.error((Object)(" Failed to create directory path " + directoryPath));
        }
    }

    public static String checkAndAppendDefaultFs(String path, Configuration conf) {
        if (FileFactory.getFileType(path) == FileType.CUSTOM) {
            return path;
        }
        String defaultFs = conf.get("fs.defaultFS");
        String lowerPath = path.toLowerCase();
        if (lowerPath.startsWith("hdfs://") || lowerPath.startsWith("alluxio://") || lowerPath.startsWith("viewfs://") || lowerPath.startsWith("s3n://") || lowerPath.startsWith("s3a://") || lowerPath.startsWith("s3://") || lowerPath.startsWith("file://")) {
            return path;
        }
        if (defaultFs != null) {
            return defaultFs + "/" + path;
        }
        return path;
    }

    public static boolean checkIfPrefixExists(String path) {
        if (FileFactory.getFileType(path) == FileType.CUSTOM) {
            return true;
        }
        String lowerPath = path.toLowerCase(Locale.getDefault());
        return lowerPath.contains("://") || lowerPath.startsWith("hdfs://") || lowerPath.startsWith("viewfs://") || lowerPath.startsWith("file://") || lowerPath.startsWith("alluxio://") || lowerPath.startsWith("s3n://") || lowerPath.startsWith("s3://") || lowerPath.startsWith("s3a://");
    }

    public static boolean setReplication(String path, short replication) throws IOException {
        return FileFactory.getCarbonFile(path).setReplication(replication);
    }

    public static short getDefaultReplication(String path) {
        return FileFactory.getCarbonFile(path).getDefaultReplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFile(String content, String filePath) throws IOException {
        AtomicFileOperations fileWrite = AtomicFileOperationFactory.getAtomicFileOperations(filePath);
        BufferedWriter brWriter = null;
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = fileWrite.openForWrite(FileWriteOperation.OVERWRITE);
            brWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)dataOutputStream, Charset.forName("UTF-8")));
            brWriter.write(content);
        }
        catch (IOException ie) {
            try {
                LOGGER.error((Object)("Error message: " + ie.getLocalizedMessage()));
                fileWrite.setFailed();
                throw ie;
            }
            catch (Throwable throwable) {
                try {
                    CarbonUtil.closeStreams(brWriter);
                    throw throwable;
                }
                finally {
                    fileWrite.close();
                }
            }
        }
        try {
            CarbonUtil.closeStreams(brWriter);
            return;
        }
        finally {
            fileWrite.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLinesInFile(String filePath, Configuration conf) throws IOException {
        List<String> list;
        DataInputStream fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = FileFactory.getDataInputStream(filePath, -1, conf);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileReader, Charset.forName("UTF-8")));
            list = bufferedReader.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            CarbonUtil.closeStreams(fileReader, bufferedReader);
            throw throwable;
        }
        CarbonUtil.closeStreams(fileReader, bufferedReader);
        return list;
    }

    public static void touchFile(CarbonFile file) throws IOException {
        if (file.exists()) {
            return;
        }
        FileFactory.touchDirectory(file.getParentFile());
        file.createNewFile();
    }

    public static void touchFile(CarbonFile file, FsPermission permission) throws IOException {
        if (file.exists()) {
            return;
        }
        FileFactory.touchDirectory(file.getParentFile(), permission);
        file.createNewFile(permission);
    }

    public static void touchDirectory(CarbonFile directory) throws IOException {
        if (directory.exists()) {
            return;
        }
        FileFactory.touchDirectory(directory.getParentFile());
        directory.mkdirs();
    }

    public static void touchDirectory(CarbonFile directory, FsPermission permission) throws IOException {
        if (directory.exists()) {
            return;
        }
        FileFactory.touchDirectory(directory.getParentFile(), permission);
        FileFactory.createDirectoryAndSetPermission(directory.getCanonicalPath(), permission);
    }

    static {
        configuration.addResource(new Path("../core-default.xml"));
        fileFileTypeInterface = new DefaultFileTypeProvider();
    }

    public static enum FileType {
        LOCAL,
        HDFS,
        ALLUXIO,
        VIEWFS,
        S3,
        CUSTOM,
        HDFS_LOCAL;

    }
}

