/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.apache.carbondata.core.datastore.FileReader;

public class FileReaderImpl
implements FileReader {
    private Map<String, FileChannel> fileNameAndStreamCache;
    private boolean readPageByPage;

    public FileReaderImpl() {
        this.fileNameAndStreamCache = new HashMap<String, FileChannel>(16);
    }

    public FileReaderImpl(int capacity) {
        this.fileNameAndStreamCache = new HashMap<String, FileChannel>(capacity);
    }

    @Override
    public byte[] readByteArray(String filePath, long offset, int length) throws IOException {
        FileChannel fileChannel = this.updateCache(filePath);
        ByteBuffer byteBuffer = this.read(fileChannel, length, offset);
        return byteBuffer.array();
    }

    @Override
    public void finish() throws IOException {
        for (Map.Entry<String, FileChannel> entry : this.fileNameAndStreamCache.entrySet()) {
            FileChannel channel = entry.getValue();
            if (null == channel) continue;
            channel.close();
        }
        this.fileNameAndStreamCache.clear();
    }

    @Override
    public int readInt(String filePath, long offset) throws IOException {
        FileChannel fileChannel = this.updateCache(filePath);
        ByteBuffer byteBuffer = this.read(fileChannel, 4, offset);
        return byteBuffer.getInt();
    }

    @Override
    public int readInt(String filePath) throws IOException {
        FileChannel fileChannel = this.updateCache(filePath);
        ByteBuffer byteBuffer = this.read(fileChannel, 4);
        return byteBuffer.getInt();
    }

    @Override
    public long readDouble(String filePath, long offset) throws IOException {
        FileChannel fileChannel = this.updateCache(filePath);
        ByteBuffer byteBuffer = this.read(fileChannel, 8, offset);
        return byteBuffer.getLong();
    }

    private FileChannel updateCache(String filePath) throws FileNotFoundException {
        FileChannel fileChannel = this.fileNameAndStreamCache.get(filePath);
        if (null == fileChannel) {
            FileInputStream stream = new FileInputStream(filePath);
            fileChannel = stream.getChannel();
            this.fileNameAndStreamCache.put(filePath, fileChannel);
        }
        return fileChannel;
    }

    private ByteBuffer read(FileChannel channel, int size, long offset) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        channel.position(offset);
        channel.read(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    private ByteBuffer read(FileChannel channel, int size) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        channel.read(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    @Override
    public byte[] readByteArray(String filePath, int length) throws IOException {
        FileChannel fileChannel = this.updateCache(filePath);
        ByteBuffer byteBuffer = this.read(fileChannel, length);
        return byteBuffer.array();
    }

    @Override
    public long readLong(String filePath, long offset) throws IOException {
        FileChannel fileChannel = this.updateCache(filePath);
        ByteBuffer byteBuffer = this.read(fileChannel, 8, offset);
        return byteBuffer.getLong();
    }

    @Override
    public ByteBuffer readByteBuffer(String filePath, long offset, int length) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        FileChannel fileChannel = this.updateCache(filePath);
        fileChannel.position(offset);
        fileChannel.read(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    @Override
    public void setReadPageByPage(boolean isReadPageByPage) {
        this.readPageByPage = isReadPageByPage;
    }

    @Override
    public boolean isReadPageByPage() {
        return this.readPageByPage;
    }
}

