/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.util.concurrent.Callable;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.page.FallbackEncodedColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.EncodedColumnPage;
import org.apache.carbondata.core.util.CarbonUtil;

public class ActualDataBasedFallbackEncoder
implements Callable<FallbackEncodedColumnPage> {
    private EncodedColumnPage encodedColumnPage;
    private int pageIndex;

    public ActualDataBasedFallbackEncoder(EncodedColumnPage encodedColumnPage, int pageIndex) {
        this.encodedColumnPage = encodedColumnPage;
        this.pageIndex = pageIndex;
    }

    @Override
    public FallbackEncodedColumnPage call() throws Exception {
        this.encodedColumnPage.getActualPage().disableLocalDictEncoding();
        TableSpec.ColumnSpec columnSpec = this.encodedColumnPage.getActualPage().getColumnSpec();
        FallbackEncodedColumnPage fallbackEncodedColumnPage = CarbonUtil.getFallBackEncodedColumnPage(this.encodedColumnPage.getActualPage(), this.pageIndex, columnSpec);
        this.encodedColumnPage.freeMemory();
        this.encodedColumnPage.cleanBuffer();
        return fallbackEncodedColumnPage;
    }
}

