/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.LVByteBufferColumnPage;
import org.apache.carbondata.core.datastore.page.LocalDictColumnPage;
import org.apache.carbondata.core.datastore.page.SafeDecimalColumnPage;
import org.apache.carbondata.core.datastore.page.SafeFixLengthColumnPage;
import org.apache.carbondata.core.datastore.page.SafeVarLengthColumnPage;
import org.apache.carbondata.core.datastore.page.UnsafeDecimalColumnPage;
import org.apache.carbondata.core.datastore.page.UnsafeFixLengthColumnPage;
import org.apache.carbondata.core.datastore.page.UnsafeVarLengthColumnPage;
import org.apache.carbondata.core.datastore.page.VarLengthColumnPageBase;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.encoding.bool.BooleanConvert;
import org.apache.carbondata.core.datastore.page.statistics.ColumnPageStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.localdictionary.PageLevelDictionary;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.CarbonProperties;

public abstract class ColumnPage {
    protected int pageSize;
    protected ColumnPageEncoderMeta columnPageEncoderMeta;
    protected BitSet nullBitSet;
    protected ColumnPageStatsCollector statsCollector;
    protected static final boolean unsafe = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("enable.unsafe.columnpage", "true"));

    protected ColumnPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        this.pageSize = pageSize;
        this.nullBitSet = new BitSet(pageSize);
        this.columnPageEncoderMeta = columnPageEncoderMeta;
    }

    public DataType getDataType() {
        return this.columnPageEncoderMeta.getStoreDataType();
    }

    public SimpleStatsResult getStatistics() {
        return this.statsCollector.getPageStats();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setStatsCollector(ColumnPageStatsCollector statsCollector) {
        this.statsCollector = statsCollector;
    }

    private static ColumnPage createDecimalPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        if (ColumnPage.isUnsafeEnabled(columnPageEncoderMeta)) {
            return new UnsafeDecimalColumnPage(columnPageEncoderMeta, pageSize);
        }
        return new SafeDecimalColumnPage(columnPageEncoderMeta, pageSize);
    }

    private static ColumnPage createVarLengthPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        if (ColumnPage.isUnsafeEnabled(columnPageEncoderMeta)) {
            return new UnsafeVarLengthColumnPage(columnPageEncoderMeta, pageSize);
        }
        return new SafeVarLengthColumnPage(columnPageEncoderMeta, pageSize);
    }

    private static ColumnPage createFixLengthPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        if (ColumnPage.isUnsafeEnabled(columnPageEncoderMeta)) {
            return new UnsafeFixLengthColumnPage(columnPageEncoderMeta, pageSize);
        }
        return new SafeFixLengthColumnPage(columnPageEncoderMeta, pageSize);
    }

    private static ColumnPage createFixLengthByteArrayPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize, int eachValueSize) {
        if (ColumnPage.isUnsafeEnabled(columnPageEncoderMeta)) {
            return new UnsafeFixLengthColumnPage(columnPageEncoderMeta, pageSize, eachValueSize);
        }
        return new SafeFixLengthColumnPage(columnPageEncoderMeta, pageSize);
    }

    private static ColumnPage createPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        if (DataTypes.isDecimal(columnPageEncoderMeta.getStoreDataType())) {
            return ColumnPage.createDecimalPage(columnPageEncoderMeta, pageSize);
        }
        if (columnPageEncoderMeta.getStoreDataType().equals(DataTypes.BYTE_ARRAY)) {
            return ColumnPage.createVarLengthPage(columnPageEncoderMeta, pageSize);
        }
        return ColumnPage.createFixLengthPage(columnPageEncoderMeta, pageSize);
    }

    public static ColumnPage newDecimalPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        return ColumnPage.newPage(columnPageEncoderMeta, pageSize);
    }

    public static ColumnPage newLocalDictPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize, LocalDictionaryGenerator localDictionaryGenerator, boolean isComplexTypePrimitive) {
        ColumnPage encodedPage;
        ColumnPage actualPage;
        boolean isDecoderBasedFallBackEnabled = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("carbon.local.dictionary.decoder.fallback", "true"));
        if (ColumnPage.isUnsafeEnabled(columnPageEncoderMeta)) {
            DataType dataType = columnPageEncoderMeta.getStoreDataType();
            actualPage = dataType == DataTypes.STRING || dataType == DataTypes.VARCHAR || dataType == DataTypes.BINARY ? new LVByteBufferColumnPage(columnPageEncoderMeta, pageSize) : new UnsafeVarLengthColumnPage(columnPageEncoderMeta, pageSize);
            encodedPage = new UnsafeFixLengthColumnPage(new ColumnPageEncoderMeta(columnPageEncoderMeta.getColumnSpec(), DataTypes.BYTE_ARRAY, columnPageEncoderMeta.getCompressorName()), pageSize, 3);
        } else {
            actualPage = new SafeVarLengthColumnPage(columnPageEncoderMeta, pageSize);
            encodedPage = new SafeFixLengthColumnPage(new ColumnPageEncoderMeta(columnPageEncoderMeta.getColumnSpec(), DataTypes.BYTE_ARRAY, columnPageEncoderMeta.getCompressorName()), pageSize);
        }
        return new LocalDictColumnPage(actualPage, encodedPage, localDictionaryGenerator, isComplexTypePrimitive, isDecoderBasedFallBackEnabled);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColumnPage newPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        DataType dataType = columnPageEncoderMeta.getStoreDataType();
        TableSpec.ColumnSpec columnSpec = columnPageEncoderMeta.getColumnSpec();
        String compressorName = columnPageEncoderMeta.getCompressorName();
        if (ColumnPage.isUnsafeEnabled(columnPageEncoderMeta)) {
            if (dataType == DataTypes.BOOLEAN) {
                return new UnsafeFixLengthColumnPage(new ColumnPageEncoderMeta(columnSpec, DataTypes.BYTE, compressorName), pageSize);
            }
            if (dataType == DataTypes.BYTE) return new UnsafeFixLengthColumnPage(columnPageEncoderMeta, pageSize);
            if (dataType == DataTypes.SHORT) return new UnsafeFixLengthColumnPage(columnPageEncoderMeta, pageSize);
            if (dataType == DataTypes.SHORT_INT) return new UnsafeFixLengthColumnPage(columnPageEncoderMeta, pageSize);
            if (dataType == DataTypes.INT) return new UnsafeFixLengthColumnPage(columnPageEncoderMeta, pageSize);
            if (dataType == DataTypes.LONG) return new UnsafeFixLengthColumnPage(columnPageEncoderMeta, pageSize);
            if (dataType == DataTypes.FLOAT) return new UnsafeFixLengthColumnPage(columnPageEncoderMeta, pageSize);
            if (dataType == DataTypes.DOUBLE) {
                return new UnsafeFixLengthColumnPage(columnPageEncoderMeta, pageSize);
            }
            if (dataType == DataTypes.TIMESTAMP) {
                return new UnsafeFixLengthColumnPage(new ColumnPageEncoderMeta(columnSpec, DataTypes.LONG, compressorName), pageSize);
            }
            if (DataTypes.isDecimal(dataType)) {
                return new UnsafeDecimalColumnPage(columnPageEncoderMeta, pageSize);
            }
            if (dataType == DataTypes.STRING) return new LVByteBufferColumnPage(columnPageEncoderMeta, pageSize);
            if (dataType == DataTypes.VARCHAR) return new LVByteBufferColumnPage(columnPageEncoderMeta, pageSize);
            if (dataType == DataTypes.BINARY) {
                return new LVByteBufferColumnPage(columnPageEncoderMeta, pageSize);
            }
            if (dataType != DataTypes.BYTE_ARRAY) throw new RuntimeException("Unsupported data dataType: " + dataType);
            return new UnsafeVarLengthColumnPage(columnPageEncoderMeta, pageSize);
        }
        if (dataType == DataTypes.BOOLEAN) return ColumnPage.newBytePage(columnPageEncoderMeta, new byte[pageSize]);
        if (dataType == DataTypes.BYTE) {
            return ColumnPage.newBytePage(columnPageEncoderMeta, new byte[pageSize]);
        }
        if (dataType == DataTypes.SHORT) {
            return ColumnPage.newShortPage(columnPageEncoderMeta, new short[pageSize]);
        }
        if (dataType == DataTypes.SHORT_INT) {
            return ColumnPage.newShortIntPage(columnPageEncoderMeta, new byte[pageSize * 3]);
        }
        if (dataType == DataTypes.INT) {
            return ColumnPage.newIntPage(columnPageEncoderMeta, new int[pageSize]);
        }
        if (dataType == DataTypes.LONG) return ColumnPage.newLongPage(new ColumnPageEncoderMeta(columnPageEncoderMeta.getColumnSpec(), DataTypes.LONG, columnPageEncoderMeta.getCompressorName()), new long[pageSize]);
        if (dataType == DataTypes.TIMESTAMP) {
            return ColumnPage.newLongPage(new ColumnPageEncoderMeta(columnPageEncoderMeta.getColumnSpec(), DataTypes.LONG, columnPageEncoderMeta.getCompressorName()), new long[pageSize]);
        }
        if (dataType == DataTypes.FLOAT) {
            return ColumnPage.newFloatPage(columnPageEncoderMeta, new float[pageSize]);
        }
        if (dataType == DataTypes.DOUBLE) {
            return ColumnPage.newDoublePage(columnPageEncoderMeta, new double[pageSize]);
        }
        if (DataTypes.isDecimal(dataType)) {
            return ColumnPage.newDecimalPage(columnPageEncoderMeta, new byte[pageSize][]);
        }
        if (dataType == DataTypes.STRING) return new LVByteBufferColumnPage(columnPageEncoderMeta, pageSize);
        if (dataType == DataTypes.VARCHAR) return new LVByteBufferColumnPage(columnPageEncoderMeta, pageSize);
        if (dataType == DataTypes.BINARY) {
            return new LVByteBufferColumnPage(columnPageEncoderMeta, pageSize);
        }
        if (dataType != DataTypes.BYTE_ARRAY) throw new RuntimeException("Unsupported data dataType: " + dataType);
        return new SafeVarLengthColumnPage(columnPageEncoderMeta, pageSize);
    }

    private static ColumnPage newBytePage(ColumnPageEncoderMeta meta, byte[] byteData) {
        ColumnPageEncoderMeta encoderMeta = new ColumnPageEncoderMeta(meta.getColumnSpec(), DataTypes.BYTE, meta.getCompressorName());
        encoderMeta.setFillCompleteVector(meta.isFillCompleteVector());
        ColumnPage columnPage = ColumnPage.createPage(encoderMeta, byteData.length);
        columnPage.setBytePage(byteData);
        return columnPage;
    }

    private static ColumnPage newShortPage(ColumnPageEncoderMeta meta, short[] shortData) {
        ColumnPage columnPage = ColumnPage.createPage(meta, shortData.length);
        columnPage.setShortPage(shortData);
        return columnPage;
    }

    private static ColumnPage newShortIntPage(ColumnPageEncoderMeta meta, byte[] shortIntData) {
        ColumnPage columnPage = ColumnPage.createPage(meta, shortIntData.length / 3);
        columnPage.setShortIntPage(shortIntData);
        return columnPage;
    }

    private static ColumnPage newIntPage(ColumnPageEncoderMeta meta, int[] intData) {
        ColumnPage columnPage = ColumnPage.createPage(meta, intData.length);
        columnPage.setIntPage(intData);
        return columnPage;
    }

    private static ColumnPage newLongPage(ColumnPageEncoderMeta meta, long[] longData) {
        ColumnPage columnPage = ColumnPage.createPage(meta, longData.length);
        columnPage.setLongPage(longData);
        return columnPage;
    }

    private static ColumnPage newFloatPage(ColumnPageEncoderMeta meta, float[] floatData) {
        ColumnPage columnPage = ColumnPage.createPage(meta, floatData.length);
        columnPage.setFloatPage(floatData);
        return columnPage;
    }

    private static ColumnPage newDoublePage(ColumnPageEncoderMeta meta, double[] doubleData) {
        ColumnPage columnPage = ColumnPage.createPage(meta, doubleData.length);
        columnPage.setDoublePage(doubleData);
        return columnPage;
    }

    private static ColumnPage newDecimalPage(ColumnPageEncoderMeta meta, byte[][] byteArray) {
        ColumnPageEncoderMeta encoderMeta = new ColumnPageEncoderMeta(meta.getColumnSpec(), meta.getColumnSpec().getSchemaDataType(), meta.getCompressorName());
        encoderMeta.setFillCompleteVector(meta.isFillCompleteVector());
        ColumnPage columnPage = ColumnPage.createPage(encoderMeta, byteArray.length);
        columnPage.setByteArrayPage(byteArray);
        return columnPage;
    }

    private static ColumnPage newDecimalPage(ColumnPageEncoderMeta meta, byte[] lvEncodedByteArray) {
        return VarLengthColumnPageBase.newDecimalColumnPage(meta, lvEncodedByteArray, lvEncodedByteArray.length);
    }

    private static ColumnPage newLVBytesPage(TableSpec.ColumnSpec columnSpec, byte[] lvEncodedByteArray, int lvLength, String compressorName) {
        return VarLengthColumnPageBase.newLVBytesColumnPage(columnSpec, lvEncodedByteArray, lvLength, compressorName);
    }

    private static ColumnPage newComplexLVBytesPage(TableSpec.ColumnSpec columnSpec, byte[] lvEncodedByteArray, int lvLength, String compressorName) {
        return VarLengthColumnPageBase.newComplexLVBytesColumnPage(columnSpec, lvEncodedByteArray, lvLength, compressorName);
    }

    private static ColumnPage newFixedByteArrayPage(TableSpec.ColumnSpec columnSpec, byte[] lvEncodedByteArray, int eachValueSize, String compressorName) {
        int pageSize = lvEncodedByteArray.length / eachValueSize;
        ColumnPage fixLengthByteArrayPage = ColumnPage.createFixLengthByteArrayPage(new ColumnPageEncoderMeta(columnSpec, columnSpec.getSchemaDataType(), compressorName), pageSize, eachValueSize);
        byte[] data = null;
        int offset = 0;
        for (int i = 0; i < pageSize; ++i) {
            data = new byte[eachValueSize];
            System.arraycopy(lvEncodedByteArray, offset, data, 0, eachValueSize);
            fixLengthByteArrayPage.putBytes(i, data);
            offset += eachValueSize;
        }
        return fixLengthByteArrayPage;
    }

    public abstract void setBytePage(byte[] var1);

    public abstract void setShortPage(short[] var1);

    public abstract void setShortIntPage(byte[] var1);

    public abstract void setIntPage(int[] var1);

    public abstract void setLongPage(long[] var1);

    public abstract void setFloatPage(float[] var1);

    public abstract void setDoublePage(double[] var1);

    public abstract void setByteArrayPage(byte[][] var1);

    public abstract void freeMemory();

    public void putData(int rowId, Object value) {
        if (value == null) {
            this.putNull(rowId);
            this.statsCollector.updateNull(rowId);
            this.nullBitSet.set(rowId);
            return;
        }
        DataType dataType = this.columnPageEncoderMeta.getStoreDataType();
        if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE) {
            if (this.columnPageEncoderMeta.getColumnSpec().getSchemaDataType() == DataTypes.BOOLEAN) {
                value = BooleanConvert.boolean2Byte((Boolean)value);
            }
            this.putByte(rowId, (Byte)value);
            this.statsCollector.update((Byte)value);
        } else if (dataType == DataTypes.SHORT) {
            this.putShort(rowId, (Short)value);
            this.statsCollector.update((Short)value);
        } else if (dataType == DataTypes.INT) {
            this.putInt(rowId, (Integer)value);
            this.statsCollector.update((Integer)value);
        } else if (dataType == DataTypes.LONG) {
            this.putLong(rowId, (Long)value);
            this.statsCollector.update((Long)value);
        } else if (dataType == DataTypes.DOUBLE) {
            this.putDouble(rowId, (Double)value);
            this.statsCollector.update((Double)value);
        } else if (DataTypes.isDecimal(dataType)) {
            this.putDecimal(rowId, (BigDecimal)value);
            this.statsCollector.update((BigDecimal)value);
        } else if (dataType == DataTypes.STRING || dataType == DataTypes.BYTE_ARRAY || dataType == DataTypes.VARCHAR) {
            this.putBytes(rowId, (byte[])value);
            this.statsCollector.update((byte[])value);
        } else if (dataType == DataTypes.FLOAT) {
            this.putFloat(rowId, ((Float)value).floatValue());
            this.statsCollector.update(((Float)value).floatValue());
        } else if (dataType == DataTypes.BINARY) {
            this.putBytes(rowId, (byte[])value);
            this.statsCollector.update((byte[])value);
        } else {
            throw new RuntimeException("unsupported data type: " + dataType);
        }
    }

    public Object getData(int rowId) {
        if (this.nullBitSet.get(rowId)) {
            return this.getNull(rowId);
        }
        DataType dataType = this.columnPageEncoderMeta.getStoreDataType();
        if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE) {
            byte value = this.getByte(rowId);
            if (this.columnPageEncoderMeta.getColumnSpec().getSchemaDataType() == DataTypes.BOOLEAN) {
                return BooleanConvert.byte2Boolean(value);
            }
            return value;
        }
        if (dataType == DataTypes.SHORT) {
            return this.getShort(rowId);
        }
        if (dataType == DataTypes.INT) {
            return this.getInt(rowId);
        }
        if (dataType == DataTypes.LONG) {
            return this.getLong(rowId);
        }
        if (dataType == DataTypes.DOUBLE) {
            return this.getDouble(rowId);
        }
        if (DataTypes.isDecimal(dataType)) {
            return this.getDecimal(rowId);
        }
        if (dataType == DataTypes.STRING || dataType == DataTypes.BYTE_ARRAY || dataType == DataTypes.VARCHAR) {
            return this.getBytes(rowId);
        }
        throw new RuntimeException("unsupported data type: " + dataType);
    }

    public abstract void putByte(int var1, byte var2);

    public abstract void putShort(int var1, short var2);

    public abstract void putInt(int var1, int var2);

    public abstract void putLong(int var1, long var2);

    public abstract void putDouble(int var1, double var2);

    public abstract void putFloat(int var1, float var2);

    public abstract void putBytes(int var1, byte[] var2);

    public abstract void putDecimal(int var1, BigDecimal var2);

    public abstract void putShortInt(int var1, int var2);

    public void putBoolean(int rowId, boolean value) {
        this.putByte(rowId, BooleanConvert.boolean2Byte(value));
    }

    public abstract void putBytes(int var1, byte[] var2, int var3, int var4);

    protected void putNull(int rowId) {
        DataType dataType = this.columnPageEncoderMeta.getStoreDataType();
        if (dataType == DataTypes.BOOLEAN) {
            this.putBoolean(rowId, false);
        } else if (dataType == DataTypes.BYTE) {
            this.putByte(rowId, (byte)0);
        } else if (dataType == DataTypes.SHORT) {
            this.putShort(rowId, (short)0);
        } else if (dataType == DataTypes.INT) {
            this.putInt(rowId, 0);
        } else if (dataType == DataTypes.LONG) {
            this.putLong(rowId, 0L);
        } else if (dataType == DataTypes.DOUBLE) {
            this.putDouble(rowId, 0.0);
        } else if (dataType == DataTypes.FLOAT) {
            this.putFloat(rowId, 0.0f);
        } else if (DataTypes.isDecimal(dataType)) {
            this.putDecimal(rowId, BigDecimal.ZERO);
        } else {
            throw new IllegalArgumentException("unsupported data type: " + dataType);
        }
    }

    private Object getNull(int rowId) {
        Comparable<Boolean> result;
        DataType dataType = this.columnPageEncoderMeta.getStoreDataType();
        if (dataType == DataTypes.BOOLEAN) {
            result = this.getBoolean(rowId);
        } else if (dataType == DataTypes.BYTE) {
            result = this.getByte(rowId);
            if (this.columnPageEncoderMeta.getColumnSpec().getSchemaDataType() == DataTypes.BOOLEAN) {
                result = BooleanConvert.byte2Boolean(((Byte)result).byteValue());
            }
        } else if (dataType == DataTypes.SHORT) {
            result = this.getShort(rowId);
        } else if (dataType == DataTypes.INT) {
            result = this.getInt(rowId);
        } else if (dataType == DataTypes.LONG) {
            result = this.getLong(rowId);
        } else if (dataType == DataTypes.DOUBLE) {
            result = this.getDouble(rowId);
        } else if (DataTypes.isDecimal(dataType)) {
            result = this.getDecimal(rowId);
        } else {
            throw new IllegalArgumentException("unsupported data type: " + dataType);
        }
        return result;
    }

    public abstract byte getByte(int var1);

    public abstract short getShort(int var1);

    public abstract int getShortInt(int var1);

    public boolean getBoolean(int rowId) {
        return BooleanConvert.byte2Boolean(this.getByte(rowId));
    }

    public abstract int getInt(int var1);

    public abstract long getLong(int var1);

    public abstract float getFloat(int var1);

    public abstract double getDouble(int var1);

    public abstract BigDecimal getDecimal(int var1);

    public abstract byte[] getBytes(int var1);

    public abstract byte[] getBytePage();

    public abstract short[] getShortPage();

    public abstract byte[] getShortIntPage();

    public byte[] getBooleanPage() {
        return this.getBytePage();
    }

    public abstract int[] getIntPage();

    public abstract long[] getLongPage();

    public abstract float[] getFloatPage();

    public abstract double[] getDoublePage();

    public abstract byte[][] getByteArrayPage();

    public abstract byte[] getLVFlattenedBytePage() throws IOException;

    public abstract byte[] getComplexChildrenLVFlattenedBytePage(DataType var1) throws IOException;

    public abstract byte[] getComplexParentFlattenedBytePage() throws IOException;

    public abstract byte[] getDecimalPage();

    public abstract void convertValue(ColumnPageValueConverter var1);

    public long getPageLengthInBytes() throws IOException {
        DataType dataType = this.columnPageEncoderMeta.getStoreDataType();
        if (dataType == DataTypes.BOOLEAN) {
            return this.getBooleanPage().length;
        }
        if (dataType == DataTypes.BYTE) {
            return this.getBytePage().length;
        }
        if (dataType == DataTypes.SHORT) {
            return this.getShortPage().length * DataTypes.SHORT.getSizeInBytes();
        }
        if (dataType == DataTypes.SHORT_INT) {
            return this.getShortIntPage().length;
        }
        if (dataType == DataTypes.INT) {
            return this.getIntPage().length * DataTypes.INT.getSizeInBytes();
        }
        if (dataType == DataTypes.LONG) {
            return this.getLongPage().length * DataTypes.LONG.getSizeInBytes();
        }
        if (dataType == DataTypes.FLOAT) {
            return this.getFloatPage().length * DataTypes.FLOAT.getSizeInBytes();
        }
        if (dataType == DataTypes.DOUBLE) {
            return this.getDoublePage().length * DataTypes.DOUBLE.getSizeInBytes();
        }
        if (DataTypes.isDecimal(dataType)) {
            return this.getDecimalPage().length;
        }
        if (dataType == DataTypes.BYTE_ARRAY && this.columnPageEncoderMeta.getColumnSpec().getColumnType() == ColumnType.COMPLEX_PRIMITIVE) {
            return this.getComplexChildrenLVFlattenedBytePage(this.columnPageEncoderMeta.getColumnSpec().getSchemaDataType()).length;
        }
        if (dataType == DataTypes.BYTE_ARRAY && (this.columnPageEncoderMeta.getColumnSpec().getColumnType() == ColumnType.COMPLEX_STRUCT || this.columnPageEncoderMeta.getColumnSpec().getColumnType() == ColumnType.COMPLEX_ARRAY || this.columnPageEncoderMeta.getColumnSpec().getColumnType() == ColumnType.PLAIN_LONG_VALUE || this.columnPageEncoderMeta.getColumnSpec().getColumnType() == ColumnType.PLAIN_VALUE)) {
            return this.getComplexParentFlattenedBytePage().length;
        }
        if (dataType == DataTypes.BYTE_ARRAY) {
            return this.getLVFlattenedBytePage().length;
        }
        throw new UnsupportedOperationException("unsupported compress column page: " + dataType);
    }

    public ByteBuffer compress(Compressor compressor) throws IOException {
        DataType dataType = this.columnPageEncoderMeta.getStoreDataType();
        if (dataType == DataTypes.STRING) {
            return compressor.compressByte(this.getByteBuffer());
        }
        if (dataType == DataTypes.BOOLEAN) {
            return compressor.compressByte(this.getBooleanPage());
        }
        if (dataType == DataTypes.BYTE) {
            return compressor.compressByte(this.getBytePage());
        }
        if (dataType == DataTypes.SHORT) {
            return compressor.compressShort(this.getShortPage());
        }
        if (dataType == DataTypes.SHORT_INT) {
            return compressor.compressByte(this.getShortIntPage());
        }
        if (dataType == DataTypes.INT) {
            return compressor.compressInt(this.getIntPage());
        }
        if (dataType == DataTypes.LONG) {
            return compressor.compressLong(this.getLongPage());
        }
        if (dataType == DataTypes.FLOAT) {
            return compressor.compressFloat(this.getFloatPage());
        }
        if (dataType == DataTypes.DOUBLE) {
            return compressor.compressDouble(this.getDoublePage());
        }
        if (DataTypes.isDecimal(dataType)) {
            return compressor.compressByte(this.getDecimalPage());
        }
        if (dataType == DataTypes.BYTE_ARRAY && this.columnPageEncoderMeta.getColumnSpec().getColumnType() == ColumnType.COMPLEX_PRIMITIVE) {
            return compressor.compressByte(this.getComplexChildrenLVFlattenedBytePage(this.columnPageEncoderMeta.getColumnSpec().getSchemaDataType()));
        }
        if (dataType == DataTypes.BYTE_ARRAY && (this.columnPageEncoderMeta.getColumnSpec().getColumnType() == ColumnType.COMPLEX_STRUCT || this.columnPageEncoderMeta.getColumnSpec().getColumnType() == ColumnType.COMPLEX_ARRAY || this.columnPageEncoderMeta.getColumnSpec().getColumnType() == ColumnType.PLAIN_LONG_VALUE || this.columnPageEncoderMeta.getColumnSpec().getColumnType() == ColumnType.PLAIN_VALUE)) {
            return compressor.compressByte(this.getComplexParentFlattenedBytePage());
        }
        if (dataType == DataTypes.BINARY) {
            return ByteBuffer.wrap(this.getLVFlattenedBytePage());
        }
        if (dataType == DataTypes.BYTE_ARRAY) {
            return compressor.compressByte(this.getLVFlattenedBytePage());
        }
        throw new UnsupportedOperationException("unsupported compress column page: " + dataType);
    }

    public static ColumnPage decompress(ColumnPageEncoderMeta meta, byte[] compressedData, int offset, int length, boolean isLVEncoded, boolean isComplexPrimitiveIntLengthEncoding) {
        Compressor compressor = CompressorFactory.getInstance().getCompressor(meta.getCompressorName());
        TableSpec.ColumnSpec columnSpec = meta.getColumnSpec();
        DataType storeDataType = meta.getStoreDataType();
        if (storeDataType == DataTypes.BOOLEAN || storeDataType == DataTypes.BYTE) {
            byte[] byteData = compressor.unCompressByte(compressedData, offset, length);
            return ColumnPage.newBytePage(meta, byteData);
        }
        if (storeDataType == DataTypes.SHORT) {
            short[] shortData = compressor.unCompressShort(compressedData, offset, length);
            return ColumnPage.newShortPage(meta, shortData);
        }
        if (storeDataType == DataTypes.SHORT_INT) {
            byte[] shortIntData = compressor.unCompressByte(compressedData, offset, length);
            return ColumnPage.newShortIntPage(meta, shortIntData);
        }
        if (storeDataType == DataTypes.INT) {
            int[] intData = compressor.unCompressInt(compressedData, offset, length);
            return ColumnPage.newIntPage(meta, intData);
        }
        if (storeDataType == DataTypes.LONG) {
            long[] longData = compressor.unCompressLong(compressedData, offset, length);
            return ColumnPage.newLongPage(meta, longData);
        }
        if (storeDataType == DataTypes.FLOAT) {
            float[] floatData = compressor.unCompressFloat(compressedData, offset, length);
            return ColumnPage.newFloatPage(meta, floatData);
        }
        if (storeDataType == DataTypes.DOUBLE) {
            double[] doubleData = compressor.unCompressDouble(compressedData, offset, length);
            return ColumnPage.newDoublePage(meta, doubleData);
        }
        if (!(isLVEncoded || storeDataType != DataTypes.BYTE_ARRAY || columnSpec.getColumnType() != ColumnType.COMPLEX_PRIMITIVE && columnSpec.getColumnType() != ColumnType.PLAIN_VALUE)) {
            byte[] lvVarBytes = compressor.unCompressByte(compressedData, offset, length);
            if (isComplexPrimitiveIntLengthEncoding) {
                return ColumnPage.newComplexLVBytesPage(columnSpec, lvVarBytes, 4, meta.getCompressorName());
            }
            return ColumnPage.newComplexLVBytesPage(columnSpec, lvVarBytes, 2, meta.getCompressorName());
        }
        if (isLVEncoded && storeDataType == DataTypes.BYTE_ARRAY && columnSpec.getColumnType() == ColumnType.COMPLEX_PRIMITIVE) {
            byte[] lvVarBytes = compressor.unCompressByte(compressedData, offset, length);
            return ColumnPage.newFixedByteArrayPage(columnSpec, lvVarBytes, 3, meta.getCompressorName());
        }
        if (storeDataType == DataTypes.BYTE_ARRAY && columnSpec.getColumnType() == ColumnType.COMPLEX_STRUCT) {
            byte[] lvVarBytes = compressor.unCompressByte(compressedData, offset, length);
            return ColumnPage.newFixedByteArrayPage(columnSpec, lvVarBytes, 2, meta.getCompressorName());
        }
        if (storeDataType == DataTypes.BYTE_ARRAY && columnSpec.getColumnType() == ColumnType.COMPLEX_ARRAY) {
            byte[] lvVarBytes = compressor.unCompressByte(compressedData, offset, length);
            return ColumnPage.newFixedByteArrayPage(columnSpec, lvVarBytes, 8, meta.getCompressorName());
        }
        if (storeDataType == DataTypes.BYTE_ARRAY && columnSpec.getColumnType() == ColumnType.PLAIN_LONG_VALUE) {
            byte[] lvVarBytes = compressor.unCompressByte(compressedData, offset, length);
            return ColumnPage.newLVBytesPage(columnSpec, lvVarBytes, 4, meta.getCompressorName());
        }
        if (storeDataType == DataTypes.BYTE_ARRAY) {
            byte[] lvVarBytes = compressor.unCompressByte(compressedData, offset, length);
            return ColumnPage.newLVBytesPage(columnSpec, lvVarBytes, 4, meta.getCompressorName());
        }
        throw new UnsupportedOperationException("unsupported uncompress column page: " + meta.getStoreDataType());
    }

    public static ColumnPage decompressDecimalPage(ColumnPageEncoderMeta meta, byte[] compressedData, int offset, int length) {
        Compressor compressor = CompressorFactory.getInstance().getCompressor(meta.getCompressorName());
        DataType storeDataType = meta.getStoreDataType();
        if (storeDataType == DataTypes.BYTE) {
            byte[] byteData = compressor.unCompressByte(compressedData, offset, length);
            ColumnPage decimalPage = ColumnPage.createDecimalPage(meta, byteData.length);
            decimalPage.setBytePage(byteData);
            return decimalPage;
        }
        if (storeDataType == DataTypes.SHORT) {
            short[] shortData = compressor.unCompressShort(compressedData, offset, length);
            ColumnPage decimalPage = ColumnPage.createDecimalPage(meta, shortData.length);
            decimalPage.setShortPage(shortData);
            return decimalPage;
        }
        if (storeDataType == DataTypes.SHORT_INT) {
            byte[] shortIntData = compressor.unCompressByte(compressedData, offset, length);
            ColumnPage decimalPage = ColumnPage.createDecimalPage(meta, shortIntData.length / 3);
            decimalPage.setShortIntPage(shortIntData);
            return decimalPage;
        }
        if (storeDataType == DataTypes.INT) {
            int[] intData = compressor.unCompressInt(compressedData, offset, length);
            ColumnPage decimalPage = ColumnPage.createDecimalPage(meta, intData.length);
            decimalPage.setIntPage(intData);
            return decimalPage;
        }
        if (storeDataType == DataTypes.LONG) {
            long[] longData = compressor.unCompressLong(compressedData, offset, length);
            ColumnPage decimalPage = ColumnPage.createDecimalPage(meta, longData.length);
            decimalPage.setLongPage(longData);
            return decimalPage;
        }
        byte[] lvEncodedBytes = compressor.unCompressByte(compressedData, offset, length);
        return ColumnPage.newDecimalPage(meta, lvEncodedBytes);
    }

    protected static boolean isUnsafeEnabled(ColumnPageEncoderMeta meta) {
        return unsafe && !meta.isFillCompleteVector();
    }

    public BitSet getNullBits() {
        return this.nullBitSet;
    }

    public void setNullBits(BitSet nullBitSet) {
        this.nullBitSet = nullBitSet;
    }

    public TableSpec.ColumnSpec getColumnSpec() {
        return this.columnPageEncoderMeta.getColumnSpec();
    }

    public boolean isLocalDictGeneratedPage() {
        return false;
    }

    public void disableLocalDictEncoding() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public PageLevelDictionary getColumnPageDictionary() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public int getActualRowCount() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public String getColumnCompressorName() {
        return this.columnPageEncoderMeta.getCompressorName();
    }

    public ColumnPageEncoderMeta getColumnPageEncoderMeta() {
        return this.columnPageEncoderMeta;
    }

    public ByteBuffer getByteBuffer() {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

