/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.statistics.DummyStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.PrimitivePageStatsCollector;
import org.apache.carbondata.core.datastore.row.ComplexColumnInfo;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.DataTypeUtil;

public class ComplexColumnPage {
    private int complexColumnIndex;
    private List<ComplexColumnInfo> complexColumnInfoList;
    private ColumnPage[] columnPages;
    private int[] currentRowIdList;

    public ComplexColumnPage(List<ComplexColumnInfo> complexColumnInfoList) {
        this.complexColumnIndex = complexColumnInfoList.size();
        this.complexColumnInfoList = complexColumnInfoList;
        this.columnPages = new ColumnPage[this.complexColumnIndex];
        this.currentRowIdList = new int[this.complexColumnIndex];
    }

    public void initialize(Map<String, LocalDictionaryGenerator> columnToDictMap, int pageSize, String columnCompressor) {
        for (int i = 0; i < this.columnPages.length; ++i) {
            LocalDictionaryGenerator localDictionaryGenerator = columnToDictMap.get(this.complexColumnInfoList.get(i).getColumnNames());
            TableSpec.ColumnSpec spec = this.getColumnSpec(i, localDictionaryGenerator);
            if (null == localDictionaryGenerator) {
                DataType dataType = this.complexColumnInfoList.get(i).getColumnDataTypes();
                if (this.isColumnPageBasedOnDataType(i)) {
                    this.columnPages[i] = ColumnPage.newPage(new ColumnPageEncoderMeta(spec, dataType, columnCompressor), pageSize);
                    this.columnPages[i].setStatsCollector(PrimitivePageStatsCollector.newInstance(dataType));
                    continue;
                }
                this.columnPages[i] = ColumnPage.newPage(new ColumnPageEncoderMeta(spec, DataTypes.BYTE_ARRAY, columnCompressor), pageSize);
                this.columnPages[i].setStatsCollector(new DummyStatsCollector());
                continue;
            }
            this.columnPages[i] = ColumnPage.newLocalDictPage(new ColumnPageEncoderMeta(spec, DataTypes.BYTE_ARRAY, columnCompressor), pageSize, localDictionaryGenerator, true);
            this.columnPages[i].setStatsCollector(new DummyStatsCollector());
        }
    }

    private TableSpec.ColumnSpec getColumnSpec(int columnPageIndex, LocalDictionaryGenerator localDictionaryGenerator) {
        if (localDictionaryGenerator == null && this.isColumnPageBasedOnDataType(columnPageIndex)) {
            return TableSpec.ColumnSpec.newInstance(this.complexColumnInfoList.get(columnPageIndex).getColumnNames(), this.complexColumnInfoList.get(columnPageIndex).getColumnDataTypes(), this.complexColumnInfoList.get(columnPageIndex).getComplexColumnType());
        }
        return TableSpec.ColumnSpec.newInstance(this.complexColumnInfoList.get(columnPageIndex).getColumnNames(), DataTypes.BYTE_ARRAY, this.complexColumnInfoList.get(columnPageIndex).getComplexColumnType());
    }

    private boolean isColumnPageBasedOnDataType(int columnPageIndex) {
        DataType dataType = this.complexColumnInfoList.get(columnPageIndex).getColumnDataTypes();
        return this.complexColumnInfoList.get(columnPageIndex).isNoDictionary() && !DataTypes.isStructType(dataType) && !DataTypes.isArrayType(dataType) && !DataTypes.isMapType(dataType) && dataType != DataTypes.STRING && dataType != DataTypes.VARCHAR && dataType != DataTypes.BINARY && dataType != DataTypes.DATE && !DataTypes.isDecimal(dataType);
    }

    public int getComplexColumnIndex() {
        return this.complexColumnIndex;
    }

    public void putComplexData(int depth, List<byte[]> dataList) {
        assert (depth <= this.complexColumnIndex);
        int positionNumber = this.currentRowIdList[depth];
        for (byte[] value : dataList) {
            if (this.columnPages[depth].getDataType() != DataTypes.BYTE_ARRAY) {
                if (value == null || value.length == 0) {
                    this.columnPages[depth].putNull(positionNumber);
                    this.columnPages[depth].statsCollector.updateNull(positionNumber);
                    this.columnPages[depth].nullBitSet.set(positionNumber);
                } else {
                    this.columnPages[depth].putData(positionNumber, DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(value, this.columnPages[depth].getColumnSpec().getSchemaDataType(), false));
                }
            } else {
                this.columnPages[depth].putData(positionNumber, value);
            }
            ++positionNumber;
        }
        this.currentRowIdList[depth] = positionNumber;
    }

    public void freeMemory() {
        for (int i = 0; i < this.complexColumnIndex; ++i) {
            this.columnPages[i].freeMemory();
        }
    }

    public ColumnPage getColumnPage(int complexColumnIndex) {
        assert (complexColumnIndex <= this.complexColumnIndex);
        return this.columnPages[complexColumnIndex];
    }
}

