/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.math.BigDecimal;
import org.apache.carbondata.core.datastore.page.UnsafeVarLengthColumnPageBase;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalConverterFactory;

public abstract class DecimalColumnPage
extends UnsafeVarLengthColumnPageBase {
    DecimalConverterFactory.DecimalConverter decimalConverter;

    DecimalColumnPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        super(columnPageEncoderMeta, pageSize);
        this.decimalConverter = DecimalConverterFactory.INSTANCE.getDecimalConverter(columnPageEncoderMeta.getColumnSpec().getPrecision(), columnPageEncoderMeta.getColumnSpec().getScale());
    }

    public DecimalConverterFactory.DecimalConverter getDecimalConverter() {
        return this.decimalConverter;
    }

    @Override
    public byte[] getBytePage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public short[] getShortPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getShortIntPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public int[] getIntPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public long[] getLongPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public float[] getFloatPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public double[] getDoublePage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[][] getByteArrayPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public float getFloat(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public double getDouble(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putDouble(int rowId, double value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putFloat(int rowId, float value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setFloatPage(float[] floatData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setDoublePage(double[] doubleData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    private BigDecimal getDecimalFromRawData(int rowId) {
        long value;
        switch (this.decimalConverter.getDecimalConverterType()) {
            case DECIMAL_INT: {
                value = this.getInt(rowId);
                break;
            }
            case DECIMAL_LONG: {
                value = this.getLong(rowId);
                break;
            }
            default: {
                value = this.getByte(rowId);
            }
        }
        return this.decimalConverter.getDecimal(value);
    }

    private BigDecimal getDecimalFromDecompressData(int rowId) {
        long value;
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.BYTE) {
            value = this.getByte(rowId);
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.SHORT) {
            value = this.getShort(rowId);
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.SHORT_INT) {
            value = this.getShortInt(rowId);
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.INT) {
            value = this.getInt(rowId);
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.LONG) {
            value = this.getLong(rowId);
        } else {
            return this.decimalConverter.getDecimal(this.getBytes(rowId));
        }
        return this.decimalConverter.getDecimal(value);
    }

    @Override
    public BigDecimal getDecimal(int rowId) {
        if (this.rowOffset.getActualRowCount() == 0) {
            return this.getDecimalFromRawData(rowId);
        }
        return this.getDecimalFromDecompressData(rowId);
    }
}

