/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.columnar.UnBlockIndexer;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.FallbackEncodedColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.EncodedColumnPage;
import org.apache.carbondata.core.keygenerator.KeyGenerator;
import org.apache.carbondata.core.keygenerator.factory.KeyGeneratorFactory;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.Encoding;

public class DecoderBasedFallbackEncoder
implements Callable<FallbackEncodedColumnPage> {
    private EncodedColumnPage encodedColumnPage;
    private int pageIndex;
    private LocalDictionaryGenerator localDictionaryGenerator;

    public DecoderBasedFallbackEncoder(EncodedColumnPage encodedColumnPage, int pageIndex, LocalDictionaryGenerator localDictionaryGenerator) {
        this.encodedColumnPage = encodedColumnPage;
        this.pageIndex = pageIndex;
        this.localDictionaryGenerator = localDictionaryGenerator;
    }

    @Override
    public FallbackEncodedColumnPage call() throws Exception {
        int pageSize = this.encodedColumnPage.getActualPage().getPageSize();
        int offset = 0;
        int[] reverseInvertedIndex = new int[pageSize];
        for (int i = 0; i < pageSize; ++i) {
            reverseInvertedIndex[i] = i;
        }
        byte[] bytes = CompressorFactory.getInstance().getCompressor(this.encodedColumnPage.getActualPage().getColumnPageEncoderMeta().getCompressorName()).unCompressByte(this.encodedColumnPage.getEncodedData().array(), offset, this.encodedColumnPage.getPageMetadata().data_page_length);
        offset += this.encodedColumnPage.getPageMetadata().data_page_length;
        ByteBuffer data = ByteBuffer.wrap(this.encodedColumnPage.getEncodedData().array());
        if (CarbonUtil.hasEncoding(this.encodedColumnPage.getPageMetadata().encoders, Encoding.INVERTED_INDEX)) {
            int[] invertedIndexes = CarbonUtil.getUnCompressColumnIndex(this.encodedColumnPage.getPageMetadata().rowid_page_length, data, offset);
            offset += this.encodedColumnPage.getPageMetadata().rowid_page_length;
            reverseInvertedIndex = CarbonUtil.getInvertedReverseIndex(invertedIndexes);
        }
        if (CarbonUtil.hasEncoding(this.encodedColumnPage.getPageMetadata().encoders, Encoding.RLE)) {
            int[] rlePage = CarbonUtil.getIntArray(data, offset, this.encodedColumnPage.getPageMetadata().rle_page_length);
            bytes = UnBlockIndexer.uncompressData(bytes, rlePage, 3, bytes.length);
        }
        this.encodedColumnPage.getActualPage().disableLocalDictEncoding();
        ColumnPage actualDataColumnPage = ColumnPage.newPage(this.encodedColumnPage.getActualPage().getColumnPageEncoderMeta(), this.encodedColumnPage.getActualPage().getPageSize());
        KeyGenerator keyGenerator = KeyGeneratorFactory.getKeyGenerator(new int[]{100001});
        actualDataColumnPage.setStatsCollector(this.encodedColumnPage.getActualPage().statsCollector);
        int rowId = 0;
        for (int i = 0; i < pageSize; ++i) {
            int index = reverseInvertedIndex[i] * 3;
            int keyArray = (int)keyGenerator.getKeyArray(bytes, index)[0];
            actualDataColumnPage.putBytes(rowId++, this.localDictionaryGenerator.getDictionaryKeyBasedOnValue(keyArray));
        }
        TableSpec.ColumnSpec columnSpec = this.encodedColumnPage.getActualPage().getColumnSpec();
        FallbackEncodedColumnPage fallBackEncodedColumnPage = CarbonUtil.getFallBackEncodedColumnPage(actualDataColumnPage, this.pageIndex, columnSpec);
        actualDataColumnPage.freeMemory();
        this.encodedColumnPage.cleanBuffer();
        return fallBackEncodedColumnPage;
    }
}

