/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import org.apache.carbondata.core.datastore.page.encoding.EncodedColumnPage;

public class EncodedTablePage {
    private EncodedColumnPage[] dimensionPages;
    private EncodedColumnPage[] measurePages;
    private int pageSize;
    private int encodedSize;

    public static EncodedTablePage newInstance(int pageSize, EncodedColumnPage[] dimensionPages, EncodedColumnPage[] measurePages) {
        return new EncodedTablePage(pageSize, dimensionPages, measurePages);
    }

    private EncodedTablePage(int pageSize, EncodedColumnPage[] dimensionPages, EncodedColumnPage[] measurePages) {
        this.dimensionPages = dimensionPages;
        this.measurePages = measurePages;
        this.pageSize = pageSize;
        this.encodedSize = this.calculatePageSize(dimensionPages, measurePages);
    }

    private int calculatePageSize(EncodedColumnPage[] dimensionPages, EncodedColumnPage[] measurePages) {
        int size = 0;
        for (EncodedColumnPage dimensionPage : dimensionPages) {
            size += dimensionPage.getTotalSerializedSize();
        }
        for (EncodedColumnPage measurePage : measurePages) {
            size += measurePage.getTotalSerializedSize();
        }
        return size;
    }

    public int getEncodedSize() {
        return this.encodedSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getNumDimensions() {
        return this.dimensionPages.length;
    }

    public int getNumMeasures() {
        return this.measurePages.length;
    }

    public EncodedColumnPage getDimension(int dimensionIndex) {
        return this.dimensionPages[dimensionIndex];
    }

    public EncodedColumnPage getMeasure(int measureIndex) {
        return this.measurePages[measureIndex];
    }

    public EncodedColumnPage[] getDimensions() {
        return this.dimensionPages;
    }

    public EncodedColumnPage[] getMeasures() {
        return this.measurePages;
    }
}

