/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import sun.nio.ch.DirectBuffer;

public class LVByteBufferColumnPage
extends ColumnPage {
    private ByteBuffer byteBuffer;
    protected ColumnPage rowOffset;
    private int numRows;
    protected int totalLength;

    LVByteBufferColumnPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        super(columnPageEncoderMeta, pageSize);
        this.checkDataType(columnPageEncoderMeta);
        TableSpec.ColumnSpec spec = TableSpec.ColumnSpec.newInstance(columnPageEncoderMeta.getColumnSpec().getFieldName(), DataTypes.INT, ColumnType.MEASURE);
        this.rowOffset = ColumnPage.newPage(new ColumnPageEncoderMeta(spec, DataTypes.INT, columnPageEncoderMeta.getCompressorName()), pageSize + 1);
        this.byteBuffer = ByteBuffer.allocateDirect((int)((double)(pageSize * 8) * 1.25));
        this.numRows = 0;
        this.totalLength = 0;
    }

    private void checkDataType(ColumnPageEncoderMeta columnPageEncoderMeta) {
        DataType dataType = columnPageEncoderMeta.getStoreDataType();
        if (dataType != DataTypes.STRING && dataType != DataTypes.VARCHAR && dataType != DataTypes.BINARY) {
            throw new UnsupportedOperationException("Unsupported data type: " + dataType);
        }
    }

    @Override
    public void putBytes(int rowId, byte[] bytes) {
        int requiredLength;
        DataType dataType = this.getDataType();
        if (dataType == DataTypes.STRING) {
            requiredLength = bytes.length + 2;
            this.ensureMaxLengthForString(requiredLength);
        } else if (dataType == DataTypes.VARCHAR || dataType == DataTypes.BINARY) {
            requiredLength = bytes.length + 4;
        } else {
            throw new UnsupportedOperationException("unsupported data type: " + dataType);
        }
        this.ensureMemory(requiredLength);
        if (dataType == DataTypes.STRING) {
            this.byteBuffer.putShort((short)bytes.length);
        } else {
            this.byteBuffer.putInt(bytes.length);
        }
        this.byteBuffer.put(bytes);
        if (rowId == 0) {
            this.rowOffset.putInt(0, 0);
        }
        this.rowOffset.putInt(rowId + 1, this.rowOffset.getInt(rowId) + requiredLength);
        this.totalLength += requiredLength;
        ++this.numRows;
    }

    protected void ensureMemory(int requestSize) {
        int capacity = this.byteBuffer.capacity();
        if (this.totalLength + requestSize > capacity) {
            int newSize = Math.max(2 * capacity, this.totalLength + requestSize);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newSize);
            CarbonUnsafe.getUnsafe().copyMemory(((DirectBuffer)((Object)this.byteBuffer)).address(), ((DirectBuffer)((Object)newBuffer)).address(), capacity);
            newBuffer.position(this.byteBuffer.position());
            UnsafeMemoryManager.destroyDirectByteBuffer(this.byteBuffer);
            this.byteBuffer = newBuffer;
        }
    }

    private void ensureMaxLengthForString(int requiredLength) {
        if (requiredLength > Short.MAX_VALUE) {
            throw new RuntimeException("input data length " + requiredLength + " bytes too long, maximum length supported is " + Short.MAX_VALUE + " bytes");
        }
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public byte[][] getByteArrayPage() {
        byte[][] output = new byte[this.numRows][];
        ByteBuffer buffer = this.byteBuffer.asReadOnlyBuffer();
        for (int rowId = 0; rowId < this.numRows; ++rowId) {
            int offset = this.rowOffset.getInt(rowId);
            int length = this.rowOffset.getInt(rowId + 1) - offset;
            buffer.position(offset);
            output[rowId] = new byte[length];
            buffer.get(output[rowId]);
        }
        return output;
    }

    @Override
    public byte[] getLVFlattenedBytePage() {
        byte[] data = new byte[this.byteBuffer.position()];
        ByteBuffer buffer = this.byteBuffer.asReadOnlyBuffer();
        buffer.flip();
        buffer.get(data);
        return data;
    }

    @Override
    public byte[] getComplexChildrenLVFlattenedBytePage(DataType dataType) {
        byte[] data = new byte[this.byteBuffer.position()];
        ByteBuffer buffer = this.byteBuffer.asReadOnlyBuffer();
        buffer.flip();
        buffer.get(data);
        return data;
    }

    @Override
    public byte[] getComplexParentFlattenedBytePage() {
        int outputOffset = 0;
        byte[] output = new byte[this.totalLength];
        ByteBuffer buffer = this.byteBuffer.asReadOnlyBuffer();
        buffer.flip();
        for (int rowId = 0; rowId < this.numRows; ++rowId) {
            int readLength;
            int offset = this.rowOffset.getInt(rowId);
            int length = this.rowOffset.getInt(rowId + 1) - this.rowOffset.getInt(rowId);
            DataType dataType = this.getDataType();
            if (dataType == DataTypes.STRING) {
                buffer.position(offset + 2);
                readLength = length - 2;
            } else {
                buffer.position(offset + 4);
                readLength = length - 4;
            }
            buffer.get(output, outputOffset, readLength);
            outputOffset += readLength;
        }
        return output;
    }

    @Override
    public long getPageLengthInBytes() {
        return this.totalLength;
    }

    @Override
    public void convertValue(ColumnPageValueConverter codec) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setBytePage(byte[] byteData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setShortPage(short[] shortData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setShortIntPage(byte[] shortIntData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setIntPage(int[] intData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setLongPage(long[] longData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setFloatPage(float[] floatData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setDoublePage(double[] doubleData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putBytes(int rowId, byte[] bytes, int offset, int length) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public byte getByte(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public short getShort(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public int getShortInt(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public int getInt(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public long getLong(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public float getFloat(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public double getDouble(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getBytePage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public short[] getShortPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getShortIntPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public int[] getIntPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public long[] getLongPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public float[] getFloatPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public double[] getDoublePage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getDecimalPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getBytes(int rowId) {
        int offset = this.rowOffset.getInt(rowId);
        int length = this.rowOffset.getInt(rowId + 1) - this.rowOffset.getInt(rowId);
        byte[] data = new byte[length];
        ByteBuffer duplicated = this.byteBuffer.asReadOnlyBuffer();
        duplicated.position(offset);
        duplicated.limit(offset + length);
        duplicated.get(data);
        return data;
    }

    @Override
    public void putDecimal(int rowId, BigDecimal decimal) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public BigDecimal getDecimal(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void setByteArrayPage(byte[][] byteArray) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void freeMemory() {
        if (null != this.rowOffset) {
            this.rowOffset.freeMemory();
            this.rowOffset = null;
        }
        if (null != this.byteBuffer) {
            UnsafeMemoryManager.destroyDirectByteBuffer(this.byteBuffer);
        }
    }

    @Override
    public void putByte(int rowId, byte value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putShort(int rowId, short value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putShortInt(int rowId, int value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putInt(int rowId, int value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putLong(int rowId, long value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putDouble(int rowId, double value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putFloat(int rowId, float value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }
}

